package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorRuleMapper;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description:
 * @author: dongwh
 * @date: 2022/3/5 10:56
 */
@Service("cdmeMonitorRuleService")
public class MonitorRuleService extends AbstractRepositorService<CdmeMonitorRuleMapper, MonitorRuleModel> implements IMonitorRuleService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorRuleService.class);

    public MonitorRuleService(CdmeMonitorRuleMapper mapper) {
        super(mapper);
    }


    @Override
    public boolean editPageSizeByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto, Integer pageSize) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        int result = mapper.update(null, Wrappers.<MonitorRuleModel>lambdaUpdate()
                .eq(MonitorRuleModel::getRuleId, ruleId)
                .eq(MonitorRuleModel::getTenantId, tenantId)
                .eq(StringUtil.isNotBlank(eocCompanyId), MonitorRuleModel::getEocCompanyId, eocCompanyId)
                .eq(StringUtil.isNotBlank(eocSiteId), MonitorRuleModel::getEocSiteId, eocSiteId)
                .eq(MonitorRuleModel::getIsEnable, FieldValConstant.RULE_ENABLE)
                .set(MonitorRuleModel::getPageSize, pageSize));
        if (result < 1) {
            LOGGER.error("sd_monitor_rule表更新pageSize = {} 失败！", pageSize);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        int result = mapper.delete(queryWrapperByRuleIdAndTenantIdAndEocmap(ruleId, tenantId, eocDto));
        if (result < 1) {
            LOGGER.error("sd_monitor_rule表删除失败，删除条件ruleId:{},tenantId:{},eoc:{}", ruleId, tenantId, eocDto);
            return false;
        }
        return true;
    }

    @Override
    public List<MonitorRuleModel> listByRuleIdAndTenantId(String ruleId, String tenantId) {
        return mapper.selectList(queryWrapperByRuleIdAndTenantId(ruleId, tenantId)
                .eq(MonitorRuleModel::getIsEnable, FieldValConstant.RULE_ENABLE));
    }

    @Override
    public MonitorRuleModel getByRuleIdAndTenantIdAndTriggerId(String ruleId, String tenantId, String triggerId) {
        return mapper.selectOne(queryWrapperByRuleIdAndTenantId(ruleId, tenantId)
                .eq(MonitorRuleModel::getTriggerId, triggerId)
                .eq(MonitorRuleModel::getIsEnable, FieldValConstant.RULE_ENABLE));
    }

    @Override
    public MonitorRuleModel getByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        LambdaQueryWrapper<MonitorRuleModel> wrapper = queryWrapperByRuleIdAndTenantId(ruleId, tenantId);
        if (StringUtil.isBlank(eocCompanyId)) {
            wrapper.isNull(MonitorRuleModel::getEocCompanyId);
        } else {
            wrapper.eq(MonitorRuleModel::getEocCompanyId, eocCompanyId);
        }
        if (StringUtil.isBlank(eocSiteId)) {
            wrapper.isNull(MonitorRuleModel::getEocSiteId);
        } else {
            wrapper.eq(MonitorRuleModel::getEocSiteId, eocSiteId);
        }
        wrapper.eq(MonitorRuleModel::getIsEnable, FieldValConstant.RULE_ENABLE);
        return mapper.selectOne(wrapper);
    }

    @Override
    public List<MonitorRuleModel> listByTenantIdAndEoc(String tenantId, EocDto eocDto) {
        return mapper.selectList(queryWrapperByEocmap(eocDto)
                .eq(MonitorRuleModel::getTenantId, tenantId)
                .orderByAsc(MonitorRuleModel::getRuleId));
    }

    @Override
    public List<MonitorRuleModel> listByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto) {
        return mapper.selectList(queryWrapperByRuleIdAndTenantIdAndEocmap(ruleId, tenantId, eocDto));
    }

    @Override
    public MonitorRuleModel getRuleByRuleIdAndTenantIdAndEocIgnoreIsEnable(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        LambdaQueryWrapper<MonitorRuleModel> wrapper = queryWrapperByRuleIdAndTenantId(ruleId, tenantId);
        if (StringUtil.isBlank(eocCompanyId)) {
            wrapper.isNull(MonitorRuleModel::getEocCompanyId);
        } else {
            wrapper.eq(MonitorRuleModel::getEocCompanyId, eocCompanyId);
        }
        if (StringUtil.isBlank(eocSiteId)) {
            wrapper.isNull(MonitorRuleModel::getEocSiteId);
        } else {
            wrapper.eq(MonitorRuleModel::getEocSiteId, eocSiteId);
        }
        return mapper.selectOne(wrapper);
    }

    /**
     * 查询条件
     *
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    private LambdaQueryWrapper<MonitorRuleModel> queryWrapperByRuleIdAndTenantIdAndEocmap(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        return queryWrapperByRuleIdAndTenantId(ruleId, tenantId)
                .eq(StringUtil.isNotBlank(eocCompanyId), MonitorRuleModel::getEocCompanyId, eocCompanyId)
                .eq(StringUtil.isNotBlank(eocSiteId), MonitorRuleModel::getEocSiteId, eocSiteId);
    }

    /**
     * 查询条件
     *
     * @param eocDto
     * @return
     */
    private LambdaQueryWrapper<MonitorRuleModel> queryWrapperByEocmap(EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        return Wrappers.<MonitorRuleModel>lambdaQuery()
                .eq(StringUtil.isNotBlank(eocCompanyId), MonitorRuleModel::getEocCompanyId, eocCompanyId)
                .eq(StringUtil.isNotBlank(eocSiteId), MonitorRuleModel::getEocSiteId, eocSiteId);
    }

    /**
     * 查询条件
     *
     * @param ruleId
     * @param tenantId
     * @return
             */
    private LambdaQueryWrapper<MonitorRuleModel> queryWrapperByRuleIdAndTenantId(String ruleId, String tenantId) {
        return Wrappers.<MonitorRuleModel>lambdaQuery()
                .eq(MonitorRuleModel::getRuleId, ruleId)
                .eq(MonitorRuleModel::getTenantId, tenantId);
    }

}
