package com.digiwin.athena.cdme.mq.producer;

import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.UUID;

/**
 * @description: mq消息生产
 * @author: zhangww
 * @date: 2021/6/11 2:27
 */
@Component("cdmeMessageProducer")
public class MessageProducer {

    @Autowired
    @Qualifier("cdmeRabbitTemplate")
    private RabbitTemplate template;

    public String sendMessage(Object object) {
        String messageId = UUID.randomUUID().toString();
        template.convertAndSend(ConfigConstant.CDC_MQ_EXCHANGE, ConfigConstant.CDC_MQ_ROUTINGKEY, object, new CorrelationData(messageId));
        return messageId;
    }
}
