package com.digiwin.athena.cdme.provider;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestBody;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.cdme.pojo.request.SyncCrossLevelRuleRequest;
import com.digiwin.athena.cdme.pojo.request.SyncRuleRequest;

/**
 * @description: 规则同步服务
 * @author: liunansheng
 * @date: 2022/2/22 9:59
 */
@DWRestfulService
public interface IRuleSyncService extends DWService {
    /**
     * 同步侦测规则
     * @param syncRuleRequest
     * @return
     */
    @DWRequestMapping(path = "rule/sync", method = DWRequestMethod.POST)
    String postMonitorRule(@DWRequestBody SyncRuleRequest syncRuleRequest);

    /**
     * 同步跨层级侦测规则
     * @param syncCrossLevelRuleRequest
     * @return
     */
    @DWRequestMapping(path = "rule/cross/sync", method = DWRequestMethod.POST)
    String postCrossLevelRule(@DWRequestBody SyncCrossLevelRuleRequest syncCrossLevelRuleRequest);
}
