/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.util;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityUtil.class);
    private static final String ALGORITHM = DWApplicationConfigUtils.getProperty((String)"cdme.SecurityUtil.ALGORITHM");
    private static final String CIPHER_TRANSFORMATION = DWApplicationConfigUtils.getProperty((String)"cdme.SecurityUtil.CIPHER_TRANSFORMATION");

    private SecurityUtil() {
    }

    public static String decodeAES(String secretFile) {
        byte[] result = new byte[]{};
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        try {
            SecretKeySpec key1 = new SecretKeySpec(Hex.decodeHex((String)secretKey), "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(2, key1);
            result = cipher.doFinal(Hex.decodeHex((String)secretFile));
        }
        catch (Exception e) {
            LOGGER.error("\u5b57\u7b26\u4e32" + secretFile + "\u4f7f\u7528decodeAES\u89e3\u5bc6\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return new String(result);
    }

    public static String getMd5Result(String inputStr) {
        String encode = "";
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            byte[] inputData = inputStr.getBytes();
            md.update(inputData);
            BigInteger bigInteger = new BigInteger(md.digest());
            encode = Base64.getEncoder().encodeToString(bigInteger.toString(64).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("\u5b57\u7b26\u4e32" + inputStr + "\u4f7f\u7528MD5\u52a0\u5bc6\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return encode;
    }

    public static String getMd5Hex(String inputStr) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            return Hex.encodeHexString((byte[])md.digest(StringUtils.getBytesUtf8((String)inputStr)));
        }
        catch (Exception e) {
            LOGGER.error("\u5b57\u7b26\u4e32" + inputStr + "\u4f7f\u7528MD5\u52a0\u5bc6\u8fd4\u56dehex\u5931\u8d25", (Throwable)e);
            return result;
        }
    }

    public static boolean isEnvValid(String secure, String type) {
        if (!SecurityUtil.isProdEnv()) {
            return true;
        }
        return SecurityUtil.verifySecure(secure, type);
    }

    private static boolean isProdEnv() {
        return ConfigConstant.THEMEMAP_DOMAIN_URL.contains("thememap.apps.digiwincloudlocal");
    }

    public static boolean verifySecure(String secure, String type) {
        if (StringUtil.isBlank(secure)) {
            LOGGER.info("\u5165\u53c2secure\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String currentTime = LocalTimeUtil.getCurrentDate(true);
        String md5Interference = "";
        if ("MonitorOpsService".equals(type)) {
            md5Interference = ConfigConstant.MONITOR_INFO_MD5_KEY;
        } else if ("RedisOperationService".equals(type)) {
            md5Interference = ConfigConstant.REDIS_MD5_KEY;
        }
        String md5Result = SecurityUtil.getMd5Result(currentTime + md5Interference);
        if (MessageDigest.isEqual(md5Result.getBytes(), secure.getBytes())) {
            return true;
        }
        LOGGER.info("\u9a8c\u8bc1\u5931\u8d25,\u65e0\u6743\u9650\u64cd\u4f5c\uff01");
        return false;
    }
}

