/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.ArgumentValidException;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.request.RuleKeyRequest;
import com.digiwin.athena.cdme.pojo.vo.MonitorOpsRuleVo;
import com.digiwin.athena.cdme.pojo.vo.SyncRuleInfoVo;
import com.digiwin.athena.cdme.provider.IRuleOpsService;
import com.digiwin.athena.cdme.provider.converter.EocDtoConverter;
import com.digiwin.athena.cdme.provider.converter.RuleVoConverter;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeRuleOpsService")
public class RuleOpsService
implements IRuleOpsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleOpsService.class);
    private final IIamClient iamClient;
    private final IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;
    private final IScheduleClient scheduleClient;

    public RuleOpsService(IIamClient iamClient, IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IScheduleClient scheduleClient) {
        this.iamClient = iamClient;
        this.ruleTriggerOperatorFacadeService = ruleTriggerOperatorFacadeService;
        this.scheduleClient = scheduleClient;
    }

    @Override
    public SyncRuleInfoVo getMonitorRule(RuleKeyRequest request) {
        LOGGER.info("\u68c0\u67e5\u6d4b\u8bd5\u79df\u6237\u540c\u6b65\u7ed3\u679c\u662f\u5426\u6210\u529f\u5165\u53c2:{}", (Object)request);
        if (StringUtil.isBlank(request.getRuleId()) || StringUtil.isBlank(request.getTenantId())) {
            throw new ArgumentValidException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        if (!this.iamClient.isTenantIdMatchByToken(request.getTenantId())) {
            throw new ArgumentValidException(ErrorCodeEnum.TOKEN_NOT_MATCH_TENANT_ID);
        }
        EocDto eocDto = EocDtoConverter.convertEocDtoByCamelCaseMap(request.getEocMap());
        MonitorRuleDto ruleDto = this.ruleTriggerOperatorFacadeService.queryRuleDetailByRuleId(request.getRuleId(), request.getTenantId(), eocDto);
        MonitorRuleModel ruleModel = ruleDto.getRuleModel();
        if (null == ruleModel) {
            LOGGER.error("\u5165\u53c2{}\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4fa6\u6d4b\u89c4\u5219\uff0c\u8bf7\u67e5\u770b\uff01", (Object)request);
            return null;
        }
        MonitorOpsRuleVo monitorOpsRuleVo = RuleVoConverter.convertModelToVo(ruleModel);
        if ("cdmeREPORT".equals(ruleModel.getCategory())) {
            return new SyncRuleInfoVo((JSON)new JSONObject(), monitorOpsRuleVo, false);
        }
        MonitorTriggerModel triggerModel = ruleDto.getTriggerModel();
        JSON standardPollingRule = JsonUtil.parse(triggerModel.getTriggerParam());
        ResultDto<String> scheduleStatusResult = this.scheduleClient.getScheduleStatus(triggerModel.getId(), request.getTenantId(), DWServiceContext.getContext().getToken());
        if (MonitorHelper.isResultFail(scheduleStatusResult)) {
            throw new BusinessException(scheduleStatusResult.getCode(), scheduleStatusResult.getMessage());
        }
        boolean scheduleInstanceStatus = "Y".equals(scheduleStatusResult.getData());
        return new SyncRuleInfoVo(standardPollingRule, monitorOpsRuleVo, scheduleInstanceStatus);
    }
}

