/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.srp.cache.impl;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Service;

@Service(value="cdmeCacheService")
public class CacheService
implements ICacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheService.class);
    private static final String PATTERN_ALL_VAL = "*";
    private static final String PREFIX = "cdme:";
    @Autowired
    @Qualifier(value="cdmeRedisTemplate")
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public <T> T get(String key) {
        return (T)(key == null ? null : this.redisTemplate.opsForValue().get((Object)key));
    }

    @Override
    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public void set(String key, Object value, int seconds) {
        this.redisTemplate.opsForValue().set((Object)key, value, (long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean delete(Collection keys) {
        long n;
        try {
            n = this.redisTemplate.delete(keys);
        }
        catch (Exception e) {
            LOGGER.error("CacheOperation\u5220\u9664redis\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01", (Throwable)e);
            return false;
        }
        if (n == 0L) {
            LOGGER.warn("\u672a\u6e05\u9664redis\u7f13\u5b58\u6570\u636e\uff0c\u8bf7\u67e5\u770b\uff01");
            return false;
        }
        if ((long)keys.size() != n) {
            LOGGER.warn("redis\u7f13\u5b58\u6e05\u9664\u4e22\u5931\uff0c\u6e05\u9664\u6570\u636e\u4e3a[{}], \u603b\u5171\u6e05\u9664\u6570\u91cf[{}], \u5b9e\u9645\u6e05\u9664\u6570\u91cf[{}]", new Object[]{JsonUtil.getJsonString(keys), keys.size(), n});
        }
        return true;
    }

    @Override
    public Set<String> keys(String keyPattern) {
        if (StringUtil.isBlank(keyPattern) || PATTERN_ALL_VAL.equals(keyPattern)) {
            return new HashSet<String>();
        }
        return (Set)this.redisTemplate.execute(connection -> {
            HashSet<String> keysTmp = new HashSet<String>();
            try (Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().match(this.serialize(keyPattern)).count(1000L).build());){
                while (cursor.hasNext()) {
                    keysTmp.add(this.deserialize(new String((byte[])cursor.next(), StandardCharsets.UTF_8)));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return keysTmp;
        });
    }

    @Override
    public Object hGet(String key, String field) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)field);
    }

    @Override
    public Map<Object, Object> hGetAll(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public void hPut(String key, Object hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, value);
    }

    @Override
    public Long hDelete(String key, Object hashKey) {
        return this.redisTemplate.opsForHash().delete((Object)key, new Object[]{hashKey});
    }

    private String deserialize(String s) {
        assert (s != null);
        int index = s.indexOf(PREFIX);
        if (index != -1) {
            return s.substring(PREFIX.length());
        }
        return s;
    }

    private String serialize(String s) {
        if (s == null) {
            return null;
        }
        return PREFIX + s;
    }
}

