package com.digiwin.athena.cdme.provider;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestBody;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.cdme.pojo.request.DeaDataRequest;
import com.digiwin.athena.cdme.pojo.vo.DeaResultVo;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

/**
 * @author zhangww
 * @description: 通过dea方式查询地端数据
 * @date 2022/7/15 16:39
 */
@DWRestfulService
@Validated
public interface IDeaService extends DWService {

    /**
     * 通过dea方式查询数据
     * @param request
     * @return
     */
    @DWRequestMapping(path = "/dea/data", method = DWRequestMethod.POST)
    DeaResultVo getDataByDea(@Valid @DWRequestBody DeaDataRequest request);

}
