package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.service.client.IEspClient;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.AbstractCreateRuleService;
import com.digiwin.athena.cdme.service.facade.rulesync.IRuleExtensionService;
import com.digiwin.athena.cdme.service.facade.rulesync.ISyncFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ILockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.concurrent.locks.Lock;

/**
 * @description: 创建侦测规则
 * @author: dongwh
 * @date: 2021/10/20 14:27
 */

@Service(FieldValConstant.MONITOR_RULE_CREATE)
public class CreateService extends AbstractCreateRuleService implements ISyncFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateService.class);

    private final ILockService lockService;

    public CreateService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IThemeMapClient themeMapClient,
                         IScheduleClient scheduleClient, IEspClient espClient, IRuleExtensionService ruleExtensionService, ILockService lockService) {
        super(ruleTriggerOperatorFacadeService, themeMapClient);
        this.lockService = lockService;
    }

    @Override
    @Transactional(value = "cdmeTransactionManager")
    public ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto) {
        LOGGER.info("创建CDC侦测规则入参: {}", ruleDto);
        Lock lock = lockService.lock(MonitorHelper.buildRedisKey(ruleDto.getTenantId(), ruleDto.getRuleId(), ruleDto.getEocMap()),
                MonitorHelper.buildOldRedisKey(ruleDto.getTenantId(), ruleDto.getRuleId(), ruleDto.getEocMap()));
        try {
            /** 插入新增规则数据 */
            ResultDto<MonitorRuleDto> saveResult = saveRule(ruleDto.getTenantId(), ruleDto.getEocMap(), ruleDto.getRuleId(), ruleDto.getEnableStatus());
            if (MonitorHelper.isResultFail(saveResult)) {
                throw new BusinessException(saveResult.getCode(), saveResult.getMessage());
            }


            LOGGER.info("创建CDC类型规则成功！");
            return ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage());
        } finally {
            lockService.unlock(lock);
        }
    }
}
