/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.config;

import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class CdmeRestTemplateConfig {
    @Value(value="${cdme.httpClientMaxTotal}")
    private int maxTotal;
    @Value(value="${cdme.httpClientMaxPerRoute}")
    private int maxPerRoute;
    @Value(value="${cdme.httpClientRequestTimeOutMilliSecond}")
    private int requestTimeOutMilliSecond;
    @Value(value="${cdme.httpClientConnectTimeOutMilliSecond}")
    private int connectTimeOutMilliSecond;
    @Value(value="${cdme.httpClientSocketTimeOutMilliSecond}")
    private int socketTimeOutMilliSecond;
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner httpRoutePlanner;

    @Bean(value={"cdmeRestTemplate"})
    public RestTemplate cdmeRestTemplate() {
        return new RestTemplate(this.httpRequestFactory());
    }

    private ClientHttpRequestFactory httpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(this.httpClient());
    }

    private HttpClient httpClient() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(this.maxTotal);
        connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeOutMilliSecond).setConnectTimeout(this.connectTimeOutMilliSecond).setConnectionRequestTimeout(this.requestTimeOutMilliSecond).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner(this.httpRoutePlanner).build();
    }
}

