/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.util;

import com.digiwin.athena.cdme.core.util.StringUtil;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class LocalTimeUtil {
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String YYYY_MM = "yyyy-MM";
    private static final DateTimeFormatter DATETIME_FMT_BY_DATE_AND_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter DATETIME_FMT_BY_MONTH = DateTimeFormatter.ofPattern("yyyy-MM");
    private static final DateTimeFormatter START_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00.000");
    private static final DateTimeFormatter END_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd 23:59:59.999");
    private static final String MONITOR_RULE_DAY = "DAY";
    private static final String MONITOR_RULE_WEEK = "WEEK";
    private static final String MONITOR_RULE_MONTH = "MONTH";
    private static final String MONITOR_RULE_SEASON = "SEASON";
    private static final String MONITOR_RULE_YEAR = "YEAR";
    private static final String PLUS_OR_MINUS_DAYS = "0";
    private static final String FIRST_DAY = "1";
    private static final String LAST_DAY = "2";
    private static final Map<String, DateTimeFormatter> TIME_HOLDER = new HashMap<String, DateTimeFormatter>(8);

    private LocalTimeUtil() {
    }

    public static String getCurrentDate(boolean isSeparateByLine) {
        LocalDate now = LocalDate.now();
        if (isSeparateByLine) {
            return now.toString();
        }
        return now.format(DATE_FMT);
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static long parseLocalDateTime(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static LocalDateTime parse(CharSequence text) {
        return LocalDateTime.parse(text);
    }

    public static String getCurrentMonth() {
        return LocalDate.now().format(DATETIME_FMT_BY_MONTH);
    }

    public static String getCurrentDateTime() {
        return LocalDateTime.now().format(DATETIME_FMT_BY_DATE_AND_TIME);
    }

    public static String getDateTimeMs(LocalDateTime time) {
        if (null == time) {
            return null;
        }
        return time.format(DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS);
    }

    public static String getDateTime(LocalDateTime time) {
        if (null == time) {
            return null;
        }
        return time.format(DATETIME_FMT_BY_DATE_AND_TIME);
    }

    public static String getCurrentDateTime(String pattern) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    private static String getDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).format(DATETIME_FMT_BY_DATE_AND_TIME);
    }

    public static String getDateTime(String timestamp) {
        return LocalTimeUtil.getDateTime(Long.parseLong(timestamp));
    }

    public static LocalDateTime parseDateTime(String timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(timestamp)), ZoneId.systemDefault());
    }

    public static LocalDateTime parseTime(String time) {
        if (StringUtil.isBlank(time)) {
            return null;
        }
        if (time.length() == 19) {
            return LocalDateTime.parse(time, DATETIME_FMT_BY_DATE_AND_TIME);
        }
        return LocalDateTime.parse(time, DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS);
    }

    public static String getDateTimeMs(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).format(DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS);
    }

    private static boolean isBefore(String srcDate, String srcFormat, String compareDate, String compareFormat) {
        LocalDateTime localDate = LocalDateTime.parse(srcDate, DateTimeFormatter.ofPattern(srcFormat));
        LocalDateTime localCompareDate = LocalDateTime.parse(compareDate, DateTimeFormatter.ofPattern(compareFormat));
        return localDate.isBefore(localCompareDate);
    }

    public static boolean isBefore(String srcDate, String compareDate) {
        return LocalTimeUtil.isBefore(srcDate, YYYY_MM_DD_HH_MM_SS, compareDate, YYYY_MM_DD_HH_MM_SS);
    }

    private static String getDateTimeByRuleDay(LocalDateTime monitorTime, String day, long addDay, DateTimeFormatter dateTimeFormatter) {
        if (PLUS_OR_MINUS_DAYS.equals(day)) {
            return Optional.of(monitorTime.plusDays(addDay).format(dateTimeFormatter)).orElse("");
        }
        if (FIRST_DAY.equals(day)) {
            return Optional.of(monitorTime.with(TemporalAdjusters.firstDayOfMonth()).format(dateTimeFormatter)).orElse("");
        }
        if (LAST_DAY.equals(day)) {
            return Optional.of(monitorTime.with(TemporalAdjusters.lastDayOfMonth()).format(dateTimeFormatter)).orElse("");
        }
        return "";
    }

    private static String getDateTimeByRuleWeek(LocalDateTime monitorTime, long range, String day, long addDay, DateTimeFormatter dateTimeFormatter) {
        LocalDate localDate = monitorTime.toLocalDate();
        if (PLUS_OR_MINUS_DAYS.equals(day)) {
            return Optional.of(localDate.plusWeeks(range).with(DayOfWeek.MONDAY).plusDays(addDay).format(dateTimeFormatter)).orElse("");
        }
        if (FIRST_DAY.equals(day)) {
            return Optional.of(localDate.plusWeeks(range).with(DayOfWeek.MONDAY).format(dateTimeFormatter)).orElse("");
        }
        if (LAST_DAY.equals(day)) {
            return Optional.of(localDate.plusWeeks(range).with(DayOfWeek.SUNDAY).format(dateTimeFormatter)).orElse("");
        }
        return "";
    }

    private static String getDateTimeByRuleMonth(LocalDateTime monitorTime, long range, String day, long addDay, DateTimeFormatter dateTimeFormatter) {
        LocalDate localDate = monitorTime.toLocalDate();
        if (PLUS_OR_MINUS_DAYS.equals(day)) {
            return Optional.of(localDate.plusMonths(range).with(TemporalAdjusters.firstDayOfMonth()).plusDays(addDay).format(dateTimeFormatter)).orElse("");
        }
        if (FIRST_DAY.equals(day)) {
            return Optional.of(localDate.plusMonths(range).with(TemporalAdjusters.firstDayOfMonth()).format(dateTimeFormatter)).orElse("");
        }
        if (LAST_DAY.equals(day)) {
            return Optional.of(localDate.plusMonths(range).with(TemporalAdjusters.lastDayOfMonth()).format(dateTimeFormatter)).orElse("");
        }
        return "";
    }

    private static String getDateTimeByRuleSeason(LocalDateTime monitorTime, long range, String day, long addDay, DateTimeFormatter dateTimeFormatter) {
        LocalDate localDate = monitorTime.toLocalDate();
        if (PLUS_OR_MINUS_DAYS.equals(day)) {
            Month month = Month.of(localDate.getMonth().firstMonthOfQuarter().getValue());
            return Optional.of(LocalDate.of(localDate.getYear(), month, 1).plusMonths(range * 3L).plusDays(addDay).format(dateTimeFormatter)).orElse("");
        }
        if (FIRST_DAY.equals(day)) {
            Month month = Month.of(localDate.getMonth().firstMonthOfQuarter().getValue());
            return Optional.of(LocalDate.of(localDate.getYear(), month, 1).plusMonths(range * 3L).format(dateTimeFormatter)).orElse("");
        }
        if (LAST_DAY.equals(day)) {
            Month month = Month.of(localDate.getMonth().firstMonthOfQuarter().getValue());
            return Optional.of(LocalDate.of(localDate.getYear(), month, 1).plusMonths(range * 3L).with(TemporalAdjusters.lastDayOfMonth()).format(dateTimeFormatter)).orElse("");
        }
        return "";
    }

    private static String getDateTimeByRuleYear(LocalDateTime monitorTime, long range, String day, long addDay, DateTimeFormatter dateTimeFormatter) {
        LocalDate localDate = monitorTime.toLocalDate();
        if (PLUS_OR_MINUS_DAYS.equals(day)) {
            return Optional.of(localDate.plusYears(range).with(TemporalAdjusters.firstDayOfYear()).plusDays(addDay).format(dateTimeFormatter)).orElse("");
        }
        if (FIRST_DAY.equals(day)) {
            return Optional.of(localDate.plusYears(range).with(TemporalAdjusters.firstDayOfYear()).format(dateTimeFormatter)).orElse("");
        }
        if (LAST_DAY.equals(day)) {
            return Optional.of(localDate.plusYears(range).with(TemporalAdjusters.lastDayOfYear()).format(dateTimeFormatter)).orElse("");
        }
        return "";
    }

    public static String getDateTime(LocalDateTime monitorTime, String period, long range, String day, long addDay, String timeType) {
        DateTimeFormatter formatter = TIME_HOLDER.get(timeType);
        String time = "";
        if (MONITOR_RULE_YEAR.equals(period)) {
            time = LocalTimeUtil.getDateTimeByRuleYear(monitorTime, range, day, addDay, formatter);
        } else if (MONITOR_RULE_SEASON.equals(period)) {
            time = LocalTimeUtil.getDateTimeByRuleSeason(monitorTime, range, day, addDay, formatter);
        } else if (MONITOR_RULE_MONTH.equals(period)) {
            time = LocalTimeUtil.getDateTimeByRuleMonth(monitorTime, range, day, addDay, formatter);
        } else if (MONITOR_RULE_WEEK.equals(period)) {
            time = LocalTimeUtil.getDateTimeByRuleWeek(monitorTime, range, day, addDay, formatter);
        } else if (MONITOR_RULE_DAY.equals(period)) {
            time = LocalTimeUtil.getDateTimeByRuleDay(monitorTime, day, addDay, formatter);
        }
        return time;
    }

    static {
        TIME_HOLDER.put("DATE_TIME_START", START_DATE_TIME_FORMATTER);
        TIME_HOLDER.put("DATE_TIME_END", END_DATE_TIME_FORMATTER);
        TIME_HOLDER.put("DATE_START", DATE_FORMATTER);
        TIME_HOLDER.put("DATE_END", DATE_FORMATTER);
        TIME_HOLDER.put("STRING_START", START_DATE_TIME_FORMATTER);
        TIME_HOLDER.put("STRING_END", END_DATE_TIME_FORMATTER);
    }
}

