/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.util;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import java.util.HashMap;
import java.util.Map;

public final class ResultHelper {
    private ResultHelper() {
    }

    public static ResultDto generateResult(ResultEnum resultTypeEnum) {
        return ResultHelper.generateResult(resultTypeEnum.getSuccess(), resultTypeEnum.getMessage());
    }

    public static <T> ResultDto<T> generateResult(ResultEnum resultTypeEnum, T result) {
        return ResultHelper.generateResult(resultTypeEnum.getSuccess(), resultTypeEnum.getMessage(), result);
    }

    public static ResultDto generateResult(boolean success, String msg) {
        return new ResultDto(success, msg);
    }

    public static <T> ResultDto<T> generateResult(boolean success, String msg, T data) {
        return new ResultDto<T>(success, msg, data);
    }

    public static <T> ResultDto<T> generateLocaleResult(boolean success, String code, T ... data) {
        String message = DWApplicationMessageResourceBundleUtils.getString((String)code, (Object[])new Object[0]);
        if (data.length == 0) {
            return new ResultDto(success, message);
        }
        return new ResultDto<T>(success, message, data[0]);
    }

    public static <T> ResultDto<T> generateSuccessResult(T data) {
        return new ResultDto<T>(true, null, data);
    }

    public static <T> ResultDto<T> generateFailResult(String message) {
        return new ResultDto<Object>(false, message, null);
    }

    public static <T> ResultDto<T> generateFailResult(String code, String message, T ... data) {
        return new ResultDto<T>(false, code, message, data);
    }

    public static <T> ResultDto<T> generateFailResult(ErrorCodeEnum errorCodeEnum, T ... data) {
        String message = DWApplicationMessageResourceBundleUtils.getString((String)errorCodeEnum.getCode(), (Object[])new Object[0]);
        if (StringUtil.isBlank(message)) {
            message = errorCodeEnum.getMessage();
        }
        return new ResultDto<T>(false, errorCodeEnum.getCode(), message, data);
    }

    public static <T> ResultDto<T> generateFailResult(String code, T ... data) {
        String message = DWApplicationMessageResourceBundleUtils.getString((String)code, (Object[])new Object[0]);
        return new ResultDto<T>(false, code, message, data);
    }

    public static String generateEAIResult(String code, String desc) {
        return DWGsonProvider.getGson().toJson((Object)new DWEAIResult(code, "", desc, new HashMap()), DWEAIResult.class);
    }

    public static String generateEAIFailResult(ErrorCodeEnum errorCodeEnum) {
        String message = DWApplicationMessageResourceBundleUtils.getString((String)errorCodeEnum.getCode(), (Object[])new Object[0]);
        return DWGsonProvider.getGson().toJson((Object)new DWEAIResult("-1", "", message, new HashMap()), DWEAIResult.class);
    }

    public static String generateEAIResult(String code, String desc, Object data) {
        return DWGsonProvider.getGson().toJson((Object)new DWEAIResult(code, "", desc, (Map)data), DWEAIResult.class);
    }
}

