/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component(value="cdmeCustomHttpClient")
class CustomHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpClient.class);
    private final RestTemplate restTemplate;

    public CustomHttpClient(@Qualifier(value="cdmeRestTemplate") RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public <T> T execute(String url, Object bodyParam, HttpHeaders headers, Class<T> cls, HttpMethod httpMethod, Object ... uriVariables) {
        headers.setContentType(MediaType.APPLICATION_JSON);
        LOGGER.debug("\u8c03\u7528doPost\u4e2d\u7684headers:[{}]", (Object)headers);
        HttpEntity httpEntity = new HttpEntity(bodyParam, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, httpMethod, httpEntity, cls, uriVariables);
        return (T)responseEntity.getBody();
    }
}

