/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.rulesync;

import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import java.util.Objects;

public abstract class AbstractCreateRuleService {
    protected final IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;
    protected final IThemeMapClient themeMapClient;

    public AbstractCreateRuleService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IThemeMapClient themeMapClient) {
        this.ruleTriggerOperatorFacadeService = ruleTriggerOperatorFacadeService;
        this.themeMapClient = themeMapClient;
    }

    protected ResultDto<MonitorRuleDto> saveRule(String tenantId, EocDto eocDto, String ruleId, String enableStatus) {
        ResultDto verifyResult = this.verify(tenantId, eocDto, ruleId, enableStatus);
        if (MonitorHelper.isResultFail(verifyResult)) {
            return verifyResult;
        }
        MonitorRuleDto ruleDto = this.themeMapClient.getRuleInfo(tenantId, eocDto, ruleId);
        this.ruleTriggerOperatorFacadeService.saveCdcRule(ruleDto, eocDto);
        return ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage(), ruleDto);
    }

    private ResultDto verify(String tenantId, EocDto eocDto, String ruleId, String scheduleStatus) {
        MonitorCdcRuleDto monitorCdcRuleDto = this.ruleTriggerOperatorFacadeService.queryCdcRuleDetailByRuleIdAndTenantId(ruleId, tenantId, eocDto);
        if (!Objects.isNull(monitorCdcRuleDto.getRuleModel())) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.RULE_ALREADY_EXISTS, new Object[0]);
        }
        return ResultHelper.generateResult(true, "");
    }
}

