package com.digiwin.athena.cdme.pojo.bo;

import com.digiwin.athena.cdme.pojo.BaseEntity;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ProcessPageDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;

import java.time.LocalDateTime;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/3 16:00
 */
public class DetectionAndExecuteContextBO extends BaseEntity {

    private EocDto eocDto;

    private LocalDateTime monitorTime;

    private ResultDto<DetectionRespBO> detectionRs;

    private ResultDto<ProcessPageDto> executeRs;

    public DetectionAndExecuteContextBO(EocDto eocDto, LocalDateTime monitorTime) {
        this.eocDto = eocDto;
        this.monitorTime = monitorTime;
    }

    public LocalDateTime getMonitorTime() {
        return monitorTime;
    }

    public void setMonitorTime(LocalDateTime monitorTime) {
        this.monitorTime = monitorTime;
    }

    public ResultDto<DetectionRespBO> getDetectionRs() {
        return detectionRs;
    }

    public void setDetectionRs(ResultDto<DetectionRespBO> detectionRs) {
        this.detectionRs = detectionRs;
    }

    public ResultDto<ProcessPageDto> getExecuteRs() {
        return executeRs;
    }

    public void setExecuteRs(ResultDto<ProcessPageDto> executeRs) {
        this.executeRs = executeRs;
    }

    public EocDto getEocDto() {
        return eocDto;
    }

    public void setEocDto(EocDto eocDto) {
        this.eocDto = eocDto;
    }

    public ResultDto getResult() {
        if (detectionRs == null) {
            return null;
        }
        if (!detectionRs.getSuccess()) {
            return detectionRs;
        }
        return executeRs;
    }
}
