package com.digiwin.athena.cdme.pojo.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.LocalDateTimeConverter;
import com.google.gson.annotations.JsonAdapter;

import java.time.LocalDateTime;

/**
 * @description: 侦测查询服务接口返回的侦测概要信息
 * @author: dongwh
 * @date: 2020/11/5 10:44
 */
public class MonitorOpsSummaryVo {
    /** 规则名称 */
    private String ruleId;
    /** trigger_id */
    private String triggerId;
    /** 创建时间 */
    @JsonAdapter(LocalDateTimeConverter.class)
    private LocalDateTime createTime;
    /** 侦测规则状态：是否可用 */
    private String isEnable;
    private String eocCompanyId;
    private String eocSiteId;

    @JSONField(name = "公司")
    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    @JSONField(name = "工厂")
    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    @JSONField(name = "规则id")
    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @JSONField(name = "排程id")
    public String getTriggerId() {
        return triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    @JSONField(name = "创建时间")
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    @JSONField(name = "是否可用")
    public String getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(String isEnable) {
        this.isEnable = isEnable;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
