/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.mq.consumer.rule;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.aop.TraceId;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.ExpireRuleDto;
import com.digiwin.athena.cdme.repository.model.MonitorOptRecordModel;
import com.digiwin.athena.cdme.service.facade.auth.IContextFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.IExpireRuleFacadeService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorOptRecordService;
import com.rabbitmq.client.Channel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="cdmeMonitorRuleExpireListener")
public class MonitorRuleExpireListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(MonitorRuleExpireListener.class);
    @Autowired
    private IContextFacadeService contextService;
    @Autowired
    private IExpireRuleFacadeService expireRuleFacadeService;
    @Autowired
    private IMonitorOptRecordService optRecordService;

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="appExpireChangeMonitorCDC", durable="true"), exchange=@Exchange(value="appExpireChange", ignoreDeclarationExceptions="true", type="fanout"))}, containerFactory="cdmeConnectionFactory", errorHandler="cdmeConsumeExceptionHandle")
    @TraceId
    public void consumeMonitorMsg(Message message, Channel channel) throws Exception {
        String queueMsg = new String(message.getBody(), StandardCharsets.UTF_8);
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u63a5\u6536\u961f\u5217appExpireChangeMonitorCDC\u7684\u6d88\u606f\u4e3a:[{}]", (Object)queueMsg);
        ExpireRuleDto expireRuleDto = this.parseMessage(queueMsg);
        MonitorOptRecordModel optRecord = new MonitorOptRecordModel(expireRuleDto, (Integer)0);
        if (Objects.equals("expire", expireRuleDto.getEventType()) || Objects.equals("clean", expireRuleDto.getEventType())) {
            try {
                this.contextService.constructIntegrationContext(expireRuleDto.getTenantId());
                this.expireRuleFacadeService.processedExpireRule(expireRuleDto);
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
                optRecord.setStatus(1);
            }
            catch (Throwable e) {
                LOGGER.error("\u5220\u9664\u8fc7\u671f\u5e94\u7528\u5bf9\u5e94\u7684\u4fa6\u6d4b\u89c4\u5219\u5931\u8d25\uff0c\u5165\u53c2\u4e3a:{}\uff01", (Object)expireRuleDto);
                throw e;
            }
            finally {
                this.optRecordService.save(optRecord);
            }
        }
        channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
    }

    private ExpireRuleDto parseMessage(String kmMessage) {
        if (StringUtil.isEmpty(kmMessage)) {
            throw new IllegalArgumentException("\u961f\u5217appExpireChangeMonitorCDC\u6536\u5230\u7684\u6d88\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u770b\uff01");
        }
        return JsonUtil.getObject(kmMessage, ExpireRuleDto.class);
    }
}

