/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.mq.consumer.rule;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.mq.consumer.rule.RuleSyncCallBack;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.repository.model.MonitorOptRecordModel;
import com.digiwin.athena.cdme.service.facade.auth.IContextFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.RuleSyncFacadeProxy;
import com.digiwin.athena.cdme.service.srp.db.IMonitorOptRecordService;
import com.rabbitmq.client.Channel;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="cdmeMonitorRuleSynListener")
public class MonitorRuleSynListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorRuleSynListener.class);
    @Autowired
    private RuleSyncFacadeProxy ruleSyncFacadeProxy;
    @Autowired
    private RuleSyncCallBack ruleSyncCallBack;
    @Autowired
    private IMonitorOptRecordService optRecordService;
    @Autowired
    private IContextFacadeService contextService;

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="MonitorRuleConfigQueueCDC", durable="true"), exchange=@Exchange(value="themeMap", ignoreDeclarationExceptions="true"), key={"MonitorRuleConfigCDC"})}, containerFactory="cdmeConnectionFactory", errorHandler="cdmeConsumeExceptionHandle")
    public void onMessage(Message message, Channel channel) throws Exception {
        MonitorOptRecordModel monitorOptRecordModel = null;
        String queueMsg = new String(message.getBody(), StandardCharsets.UTF_8);
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u63a5\u6536\u961f\u5217MonitorRuleConfigQueue\u7684\u6d88\u606f\u4e3a:[{}]", (Object)queueMsg);
        SyncRuleParamDto ruleDto = this.parseMessage(queueMsg);
        try {
            this.contextService.constructContext(ruleDto.getTenantId());
            monitorOptRecordModel = new MonitorOptRecordModel(ruleDto);
            this.synMonitorRule(ruleDto);
            monitorOptRecordModel.setStatus(1);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            this.ruleSyncCallBack.successCallBack(ruleDto.getTransactionId(), ruleDto.getRuleId());
        }
        catch (Throwable e) {
            this.ruleSyncCallBack.failCallBack(ruleDto.getTransactionId(), ruleDto.getRuleId(), e, message);
            throw e;
        }
        finally {
            if (monitorOptRecordModel != null) {
                this.optRecordService.save(monitorOptRecordModel);
            }
        }
    }

    private ResultDto synMonitorRule(SyncRuleParamDto ruleDto) {
        ResultDto synRuleResult = this.ruleSyncFacadeProxy.syncMonitorRuleHandler(ruleDto);
        if (MonitorHelper.isResultFail(synRuleResult)) {
            LOGGER.error("\u4fa6\u6d4b\u5f15\u64ce\u540c\u6b65\u4fa6\u6d4b\u89c4\u5219:{}\u5931\u8d25\uff01", (Object)ruleDto);
            String resultMessage = synRuleResult.getMessage();
            if ("\u53c2\u6570\u5bf9\u5e94\u7684\u4fa6\u6d4b\u89c4\u5219\u4fe1\u606f\u5df2\u5b58\u5728".equals(resultMessage) || "\u53c2\u6570\u6ca1\u6709\u5bf9\u5e94\u7684\u6b63\u5728\u4fa6\u6d4b\u7684\u89c4\u5219\u4fe1\u606f".equals(resultMessage)) {
                throw new BusinessException(resultMessage);
            }
        }
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u540c\u6b65\u4fa6\u6d4b\u89c4\u5219\u5165\u53c2:{}", (Object)ruleDto);
        return synRuleResult;
    }

    private SyncRuleParamDto parseMessage(String tmRule) {
        if (StringUtil.isEmpty(tmRule) || CollectionUtil.isEmpty((Map)JsonUtil.getObject(tmRule))) {
            throw new IllegalArgumentException("\u961f\u5217MonitorRuleConfigQueue\u6536\u5230\u7684\u6d88\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u770b\uff01");
        }
        return JsonUtil.getObject(tmRule, SyncRuleParamDto.class);
    }
}

