/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.aop.ExceptionRetry;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.ServiceResponseUtil;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IExecutionClient;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="cdmeExecutionClient")
public class ExecutionClient
extends AbstractExecuteClient
implements IExecutionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionClient.class);

    @Override
    @ExceptionRetry(times=3, waitTime=300L)
    public ResultDto<JSON> callExecution(Map<String, Object> executionData, boolean needSignSource) {
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u6267\u884c\u5f15\u64ce\u8bf7\u6c42\u5165\u53c2:[{}]", (Object)JsonUtil.getJsonString(executionData));
        Consumer<HttpHeaders> headerAdder = needSignSource ? headers -> headers.set("monitorProcessType", "startServiceComposer") : null;
        String respContent = this.post(ConfigConstant.POST_EXECUTE_URL, executionData, DWServiceContext.getContext().getToken(), String.class, headerAdder);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528\u6267\u884c\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)respContent);
        JSON respJsonObject = ServiceResponseUtil.parseExecutionRespData(respContent);
        if (respJsonObject == null) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.EE_400, new JSON[0]);
        }
        return ResultHelper.generateResult(true, "\u4fa6\u6d4b\u8c03\u7528\u6267\u884c\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c\u4fe1\u606f", respJsonObject);
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.EE_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR: {
                return ErrorCodeEnum.EE_500;
            }
            case BAD_GATEWAY: {
                return ErrorCodeEnum.EE_502;
            }
            case SERVICE_UNAVAILABLE: {
                return ErrorCodeEnum.EE_503;
            }
            case GATEWAY_TIMEOUT: {
                return ErrorCodeEnum.EE_504;
            }
        }
        return ErrorCodeEnum.EE_OTHER_ERR;
    }
}

