/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.LoggerFormatUtil;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.IMonitorResultLogClient;
import com.digiwin.athena.cdme.service.client.request.BaseMonitorResultLogReq;
import com.digiwin.athena.cdme.service.client.request.MonitorFailResultLogReq;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorResultLogClient")
public class MonitorResultLogClient
implements IMonitorResultLogClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorResultLogClient.class);
    private static final String EXCHANGE = "it.sys.exchange";
    private static final String ROUTING_KEY = "mon.monitor";
    private static final String ERR_ROUTING_KEY_ERR = "mon.error";
    private RabbitTemplate template;

    public MonitorResultLogClient(@Qualifier(value="cdmeRabbitTemplate") RabbitTemplate template) {
        this.template = template;
    }

    @Override
    public ResultDto<Void> logMonitorResult(List<BaseMonitorResultLogReq> resultLogReqList) {
        if (CollectionUtil.isEmpty(resultLogReqList)) {
            return ResultHelper.generateSuccessResult(null);
        }
        for (BaseMonitorResultLogReq resultLogReq : resultLogReqList) {
            this.logMonitorResult(resultLogReq);
        }
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public ResultDto<Void> logMonitorResult(BaseMonitorResultLogReq resultLogReq) {
        try {
            if (DWServiceChainContext.getContext() != null) {
                resultLogReq.setParentSessionId(DWServiceChainContext.getContext().getParentId());
                resultLogReq.setSessionId(DWServiceChainContext.getContext().getId());
                resultLogReq.setAppId(DWServiceChainContext.getContext().getAppId());
                if (DWServiceChainContext.getContext().getTraceElement() != null && DWServiceChainContext.getContext().getTraceElement().getRoot() != null) {
                    resultLogReq.setTraceId(DWServiceChainContext.getContext().getTraceElement().getRoot().getId());
                }
            }
            resultLogReq.setCreatedTime(LocalDateTime.now());
            String routingKey = resultLogReq instanceof MonitorFailResultLogReq ? ERR_ROUTING_KEY_ERR : ROUTING_KEY;
            String msgId = UUID.randomUUID().toString();
            this.template.convertAndSend(EXCHANGE, routingKey, (Object)JsonUtil.getJsonString(resultLogReq), new CorrelationData(msgId));
            LOGGER.info("\u63a8\u9001\u7ed9\u8fd0\u7ef4\u6a21\u7ec4\u6210\u529f,traceId:{},ruleId:{},eoc:{},msgId:{},\u7c7b\u578b:{}", new Object[]{resultLogReq.getTraceId(), resultLogReq.getRuleCode(), resultLogReq.getEocId(), msgId, resultLogReq.getClass().getSimpleName()});
            return ResultHelper.generateSuccessResult(null);
        }
        catch (Exception e) {
            LOGGER.error(LoggerFormatUtil.formatMessage("\u57cb\u70b9\u4fa6\u6d4b\u7ed3\u679c\u5f02\u5e38, req:{}", resultLogReq), (Throwable)e);
            return ResultHelper.generateFailResult("\u57cb\u70b9\u4fa6\u6d4b\u7ed3\u679c\u5f02\u5e38");
        }
    }
}

