/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.auth.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.auth.ITokenFacadeService;
import org.springframework.stereotype.Service;

@Service(value="cdmeTokenFacadeService")
public class TokenFacadeService
implements ITokenFacadeService {
    private IThemeMapClient themeMapClient;
    private IIamClient iamClient;

    public TokenFacadeService(IThemeMapClient themeMapClient, IIamClient iamClient) {
        this.themeMapClient = themeMapClient;
        this.iamClient = iamClient;
    }

    @Override
    public String getTenantToken(String tenantId) {
        String secretKey = this.themeMapClient.getTenantSecretKey(tenantId);
        if (StringUtil.isBlank(secretKey)) {
            return "";
        }
        JSONObject iamResult = this.iamClient.getLoginResponse(secretKey);
        if (iamResult.isEmpty()) {
            throw new BusinessException(ErrorCodeEnum.IAM_GET_TOKEN_EMPTY);
        }
        String token = iamResult.getString("token");
        if (StringUtil.isBlank(token)) {
            throw new BusinessException(ErrorCodeEnum.IAM_GET_TOKEN_EMPTY);
        }
        return token;
    }
}

