/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.eoc.impl;

import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.TriggerRepDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.service.client.IEspClient;
import com.digiwin.athena.cdme.service.facade.eoc.IMatchFacadeService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="cdmeEocMatchFacadeService")
public class EocMatchFacadeService
implements IMatchFacadeService {
    private final IEspClient espClient;

    public EocMatchFacadeService(IEspClient espClient) {
        this.espClient = espClient;
    }

    @Override
    public List<EocDto> match(MonitorRuleModel ruleModel) {
        EocDto originalRuleEoc = new EocDto(ruleModel.getEocCompanyId(), ruleModel.getEocSiteId(), ruleModel.getEocRegionId());
        List<EocDto> dispatchEocs = this.espClient.getDispatchEoc(ruleModel.getTenantId(), ruleModel.getProductName());
        return this.match(dispatchEocs, originalRuleEoc);
    }

    private List<EocDto> match(List<EocDto> eocDtos, EocDto originalRuleEoc) {
        if (CollectionUtil.isEmpty(eocDtos)) {
            return Collections.singletonList(originalRuleEoc);
        }
        EocDto dispatchEoc = eocDtos.get(0);
        int ruleWeight = MonitorHelper.calculateWeight(originalRuleEoc);
        if (ruleWeight == 0) {
            return eocDtos;
        }
        int dispatchWeight = MonitorHelper.calculateWeight(dispatchEoc);
        if (ruleWeight == 3) {
            if (dispatchWeight == 0 || dispatchWeight == 3) {
                return Collections.singletonList(originalRuleEoc);
            }
            if (dispatchWeight == 8) {
                List<EocDto> result = eocDtos.stream().filter(eocDto -> StringUtils.equals((CharSequence)originalRuleEoc.getEocCompanyId(), (CharSequence)eocDto.getEocCompanyId())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(result)) {
                    throw new BusinessException(ErrorCodeEnum.EOC_NOT_MATCH);
                }
                return result;
            }
        }
        return Collections.singletonList(originalRuleEoc);
    }

    @Override
    public List<TriggerRepDto> processEocMatchIns(List<EocDto> newEocs, List<MonitorTriggerInsModel> insModels, MonitorRuleModel ruleModel) {
        List<EocDto> dispatchEocs = this.espClient.getDispatchEoc(ruleModel.getTenantId(), ruleModel.getProductName());
        int newEocWeight = MonitorHelper.calculateWeight(newEocs.get(0));
        int dispatchWeight = MonitorHelper.calculateWeight(dispatchEocs.get(0));
        this.validEocLevel(newEocs, dispatchEocs, newEocWeight, dispatchWeight);
        if (CollectionUtil.isEmpty(insModels)) {
            return newEocs.stream().map(eocMap -> new TriggerRepDto((EocDto)eocMap, null)).collect(Collectors.toList());
        }
        if (dispatchWeight == 0) {
            return newEocs.stream().map(eocMap -> new TriggerRepDto((EocDto)eocMap, (MonitorTriggerInsModel)insModels.get(0))).collect(Collectors.toList());
        }
        ArrayList<TriggerRepDto> result = new ArrayList<TriggerRepDto>();
        if (newEocWeight == 3) {
            newEocs.stream().forEach(newEoc -> {
                Optional<MonitorTriggerInsModel> optional = insModels.stream().filter(ins -> StringUtils.equals((CharSequence)newEoc.getEocCompanyId(), (CharSequence)ins.getEocCompanyId())).findFirst();
                result.add(new TriggerRepDto((EocDto)newEoc, optional.orElse(null)));
            });
        }
        if (newEocWeight == 8) {
            newEocs.stream().forEach(newEoc -> {
                Optional<MonitorTriggerInsModel> optional = insModels.stream().filter(ins -> (StringUtil.isBlank(ins.getEocSiteId()) || StringUtils.equals((CharSequence)newEoc.getEocSiteId(), (CharSequence)ins.getEocSiteId())) && StringUtils.equals((CharSequence)newEoc.getEocCompanyId(), (CharSequence)ins.getEocCompanyId())).findFirst();
                result.add(new TriggerRepDto((EocDto)newEoc, optional.orElse(null)));
            });
        }
        return result;
    }

    private void validEocLevel(List<EocDto> newEocDtos, List<EocDto> dispatchEocs, int newEocWeight, int dispatchWeight) {
        if (newEocWeight == 0) {
            throw new BusinessException(ErrorCodeEnum.CROSS_LEVEL_TENANT_LEVEL_ERR);
        }
        if (newEocWeight < dispatchWeight) {
            throw new BusinessException(ErrorCodeEnum.CROSS_LEVEL_NEW_GRETTER_OLD_ERR);
        }
        if (dispatchWeight == 0) {
            return;
        }
        HashSet<String> newR = new HashSet<String>();
        HashSet<String> oldR = new HashSet<String>();
        boolean isEocSiteLevel = newEocWeight == dispatchWeight && newEocWeight == 8;
        for (EocDto newEocDto : newEocDtos) {
            if (isEocSiteLevel) {
                newR.add(newEocDto.getEocSiteId());
                continue;
            }
            newR.add(newEocDto.getEocCompanyId());
        }
        for (EocDto dispatchEoc : dispatchEocs) {
            if (isEocSiteLevel) {
                oldR.add(dispatchEoc.getEocSiteId());
                continue;
            }
            oldR.add(dispatchEoc.getEocCompanyId());
        }
        if (newR.size() != oldR.size() || !newR.equals(oldR)) {
            throw new BusinessException(ErrorCodeEnum.CROSS_LEVEL_NEW_EOC_NOT_MATCH);
        }
    }
}

