/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorMqDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.RuleExtensionDto;
import com.digiwin.athena.cdme.service.facade.rulesync.IRuleExtensionEventService;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="detect_after_create")
public class DetectImmediatelyEventService
implements IRuleExtensionEventService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetectImmediatelyEventService.class);
    private final RabbitTemplate template;

    public DetectImmediatelyEventService(@Qualifier(value="cdmeRabbitTemplate") RabbitTemplate template) {
        this.template = template;
    }

    @Override
    public ResultDto<Void> handle(RuleExtensionDto.Event event, MonitorRuleDto ruleDto) {
        try {
            MonitorMqDto monitorMqDto = new MonitorMqDto(ruleDto.getTenantId(), ruleDto.getTriggerId());
            String messageId = UUID.randomUUID().toString();
            this.template.convertAndSend("exchange_schedule", "routingKey.schedule.executeMonitor", (Object)JsonUtil.getJsonString(monitorMqDto), new CorrelationData(messageId));
            LOGGER.info("ruleId:{},tenantId:{},eoc:{},\u521b\u5efa\u540e\u7acb\u5373\u53d1\u8d77\u4fa6\u6d4b\u53d1\u9001\u4fa6\u6d4b\u6d88\u606f,msgId:{}", new Object[]{ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getRuleEoc(), messageId});
            return ResultHelper.generateSuccessResult(null);
        }
        catch (Exception e) {
            LOGGER.error("ruleId:{},tenantId:{},eoc:{},\u521b\u5efa\u540e\u7acb\u5373\u53d1\u8d77\u4fa6\u6d4b\u5f02\u5e38", new Object[]{ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getRuleEoc(), e});
            return ResultHelper.generateFailResult(ErrorCodeEnum.DETECT_IMMEDIATELY_EVENT_ERR, new Void[0]);
        }
    }
}

