package com.digiwin.athena.cdme.service.client;

import com.alibaba.fastjson.JSONObject;

/**
 * @description:
 * @author: dongwh
 * @date: 2021/10/19 15:45
 */
public interface IIamClient {

    /**
     * 通过iam接口校验当前租户是否是测试租户
     *
     * @param tenantId
     * @return
     */
    boolean isTest(String tenantId);

    /**
     * 解析token判断tenantId是否一致
     *
     * @param tenantId
     * @return
     */
    boolean isTenantIdMatchByToken(String tenantId);
    /**
     * 获取登录用户信息
     *
     * @param secretKey
     * @return
     * @throws Exception
     */
    JSONObject getLoginResponse(String secretKey);
    /**
     * 获取租户默认token
     */
    String getDefaultLocale();

    /**
     * 获取集成帐号信息
     *
     * @param tenantId
     * @return
     */
    JSONObject getIntegration(String tenantId);

    /**
     * 根据tenantSid获取tenantId
     * @param tenantSid
     * @return
     */
    JSONObject getTenantId(String tenantSid);
}
