package com.digiwin.athena.cdme.service.client;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.request.ExpireRuleReq;
import com.digiwin.athena.cdme.service.client.response.ActionMetaDataRes;
import com.digiwin.athena.cdme.service.client.response.ExpireRuleRes;

/**
 * @description:
 * @author: dongwh
 * @date: 2021/10/19 15:47
 */
public interface IThemeMapClient {

    /**
     * 获取租户对应的授权码
     *
     * @param tenantId
     * @return
     * @throws DWBusinessException
     */
    String getTenantSecretKey(String tenantId);

    /**
     * 获取侦测规则
     *
     * @param tenantId
     * @param eocDto
     * @param ruleId
     * @return
     */
    MonitorRuleDto getRuleInfo(String tenantId, EocDto eocDto, String ruleId);

    /**
     * 获取侦测规则
     *
     * @param tenantId
     * @param eocDto
     * @param ruleId
     * @return
     */
    MonitorCdcRuleDto getCdcRuleInfo(String tenantId, EocDto eocDto, String ruleId);

    /**
     * 获取action元数据 NOTE 临时功能-1764
     *
     * @param actionId
     * @return
     */
    ActionMetaDataRes getActionMetaData(String actionId);

    /**
     * 规则同步结果回调
     *
     * @param transactionId
     * @param ruleId
     * @param syncSuccess
     * @param errorMsg
     * @return
     */
    ResultDto<Void> syncRuleCallBack(String transactionId, String ruleId, boolean syncSuccess,
        String errorMsg);

    /**
     * 获取已过期的侦测规则
     *
     * @param expireRuleReq
     * @return
     */
    ExpireRuleRes getExpireRule(ExpireRuleReq expireRuleReq);
}
