package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorMqDto;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.RuleExtensionDto;
import com.digiwin.athena.cdme.service.facade.rulesync.IRuleExtensionEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.UUID;

/**
 * @description: 创建规则后立即发起侦测事件
 * @author: liunansheng
 * @date: 2022/4/14 16:02
 */
@Service(FieldValConstant.DETECT_AFTER_CREATE)
public class DetectImmediatelyEventService implements IRuleExtensionEventService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DetectImmediatelyEventService.class);

    private final RabbitTemplate template;

    public DetectImmediatelyEventService(@Qualifier("cdmeRabbitTemplate")RabbitTemplate template) {
        this.template = template;
    }

    @Override
    public ResultDto<Void> handle(RuleExtensionDto.Event event, MonitorRuleDto ruleDto) {
        try {
            MonitorMqDto monitorMqDto = new MonitorMqDto(ruleDto.getTenantId(), ruleDto.getTriggerId());
            String messageId = UUID.randomUUID().toString();
            template.convertAndSend(ConfigConstant.DETECT_MQ_EXCHANGE, ConfigConstant.DETECT_MQ_ROUTINGKEY, JsonUtil.getJsonString(monitorMqDto), new CorrelationData(messageId));
            LOGGER.info("ruleId:{},tenantId:{},eoc:{},创建后立即发起侦测发送侦测消息,msgId:{}",ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getRuleEoc(), messageId);
            return ResultHelper.generateSuccessResult(null);
        } catch (Exception e) {
            LOGGER.error("ruleId:{},tenantId:{},eoc:{},创建后立即发起侦测异常",ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getRuleEoc(), e);
            return ResultHelper.generateFailResult(ErrorCodeEnum.DETECT_IMMEDIATELY_EVENT_ERR);
        }
    }
}
