package com.digiwin.athena.cdme.service.srp.db;

import com.digiwin.athena.cdme.core.base.IRepositoryService;
import com.digiwin.athena.cdme.repository.IBaseMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/3/9 17:02
 */
public abstract class AbstractRepositorService<M extends IBaseMapper<T>, T> implements IRepositoryService<T> {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRepositorService.class);

    protected M mapper;

    public AbstractRepositorService(M mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean save(T entity) {

        int result = mapper.insert(entity);
        if (result < 1) {
            LOGGER.error("插入记录失败：[{}]", entity);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteById(Serializable id) {
        int result = mapper.deleteById(id);
        if (result < 1) {
            LOGGER.error("根据 ID 删除失败：[{}]", id);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteBatchIds(Collection<? extends Serializable> idList) {
        int result = mapper.deleteBatchIds(idList);
        if (result < idList.size()) {
            LOGGER.error("根据ID 批量删除失败：[{}]", idList);
            return false;
        }
        return true;
    }

    @Override
    public boolean edit(T entity) {
        int result = mapper.updateById(entity);
        if (result < 1) {
            LOGGER.error("根据 ID 修改失败：[{}]", entity);
            return false;
        }
        return true;
    }

    @Override
    public T getById(Serializable id) {
        LOGGER.info("根据 ID 查询：[{}]", id);
        return mapper.selectById(id);
    }

    @Override
    public List<T> listByBatchIds(Collection<? extends Serializable> idList) {
        LOGGER.info("根据ID 批量查询：[{}]", idList);
        return mapper.selectBatchIds(idList);
    }
}
