package com.digiwin.athena.cdme.core.handler;


import com.digiwin.athena.cdme.core.exception.Retryable;
import com.digiwin.athena.cdme.core.exception.UnRetryable;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;

/**
 * @description: 异常消息处理相关
 * @author: dongwh
 * @date: 2022/1/7 16:06
 */
@Component("cdmeConsumerErrorHandler")
public class ConsumerErrorHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerErrorHandler.class);

    /**
     * 队列消息消费异常处理逻辑
     */
    @Bean("cdmeConsumeExceptionHandle")
    RabbitListenerErrorHandler rabbitListenerErrorHandler() {
        return ((amqpMessage, message, exception) -> {
            String queueName = message.getHeaders().get("amqp_consumerQueue").toString();
            String queueMsg = new String(amqpMessage.getBody(), StandardCharsets.UTF_8);
            Channel channel = (Channel) message.getHeaders().get("amqp_channel");
            long deliveryTag = amqpMessage.getMessageProperties().getDeliveryTag();
            if (exception.getCause() instanceof IllegalArgumentException || exception.getCause() instanceof UnRetryable) {
                LOGGER.error("侦测引擎处理队列[{}]的消息异常，消息为：[{}]，请查看！[{}]", queueName, queueMsg, exception);
                channel.basicAck(deliveryTag, true);
            } else if (exception.getCause() instanceof Retryable) {
                LOGGER.error("侦测引擎处理队列[{}]的消息异常，消息为：[{}]，请查看！[{}]", queueName, queueMsg, exception);
                channel.basicReject(deliveryTag, !amqpMessage.getMessageProperties().getRedelivered());
            } else {
                LOGGER.error("侦测引擎处理队列[{}]的消息异常，消息为：[{}]，请查看！", queueName, queueMsg, exception);
                channel.basicReject(deliveryTag, !amqpMessage.getMessageProperties().getRedelivered());
            }
            return null;
        });
    }
}
