/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.execution.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.SuccessMessageEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.ExecuteRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ProcessPageDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.data.IPreDetectionService;
import com.digiwin.athena.cdme.service.facade.detection.execution.IExectionService;
import com.digiwin.athena.cdme.service.facade.detection.execution.IFinishExecutionService;
import com.digiwin.athena.cdme.service.facade.detection.execution.IProcessExecutionService;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeExecutionService")
public class ExecutionService
implements IExectionService {
    private static Logger LOGGER = LoggerFactory.getLogger(ExecutionService.class);
    private final IPreDetectionService preDetectionService;
    private final IProcessExecutionService processExecutionService;
    private final IFinishExecutionService finishExecutionService;

    public ExecutionService(IPreDetectionService preDetectionService, IProcessExecutionService processExecutionService, IFinishExecutionService finishExecutionService) {
        this.preDetectionService = preDetectionService;
        this.processExecutionService = processExecutionService;
        this.finishExecutionService = finishExecutionService;
    }

    @Override
    public ResultDto<ProcessPageDto> execute(ExecuteRequestDto requestDto) {
        MonitorRuleModel ruleModel = requestDto.getRuleModel();
        if (CollectionUtil.isEmpty((Collection)requestDto.getData()) && !MonitorHelper.isGoOn(ruleModel.getCategory(), ruleModel.getMonitorRule())) {
            if (CollectionUtil.isEmpty((Collection)requestDto.getDupData())) {
                LOGGER.info("\u4fa6\u6d4b\u5230\u7684\u6570\u636e\u4e3a\u7a7a\u4e14\u6570\u636e\u4e3a\u7a7a\u65f6\u4e0d\u518d\u7ee7\u7eed\u53d1\u8d77\u6d41\u7a0b,\u4fa6\u6d4b\u5904\u7406\u7ed3\u675f\uff01");
                return ResultHelper.generateLocaleResult(true, SuccessMessageEnum.MONITOR_DATA_EMPTY.getCode(), new ProcessPageDto[0]);
            }
            LOGGER.info("\u53bb\u91cd\u540e\u6570\u636e\u4e3a\u7a7a,\u65e0\u9700\u8c03\u7528\u6267\u884c,\u4fa6\u6d4b\u5904\u7406\u7ed3\u675f\uff01");
            return ResultHelper.generateLocaleResult(true, SuccessMessageEnum.DUP_DATA_EMPTY.getCode(), new ProcessPageDto[0]);
        }
        ResultDto<Map<String, JSONObject>> preResult = this.preDetectionService.parseConfig(requestDto.getRuleModel(), requestDto.getTimeRange());
        if (MonitorHelper.isResultFail(preResult)) {
            return ResultHelper.generateFailResult(preResult.getCode(), preResult.getMessage(), new ProcessPageDto[0]);
        }
        ProcessPageDto executeRs = this.processExecutionService.processExecutionByPage(requestDto, preResult.getData());
        if (executeRs.allFail()) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.DETECTION_ALL_FAILE, executeRs);
        }
        ResultDto<Void> finishRs = this.finishExecutionService.syncProcess(requestDto, executeRs);
        if (MonitorHelper.isResultFail(finishRs)) {
            return ResultHelper.generateFailResult(finishRs.getCode(), finishRs.getMessage(), new ProcessPageDto[]{executeRs});
        }
        if (executeRs.partFail()) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.DETECTION_PART_FAILE, executeRs);
        }
        return ResultHelper.generateLocaleResult(true, SuccessMessageEnum.ALL_PAGE_SUCCESS.getCode(), executeRs);
    }
}

