package com.digiwin.athena.cdme.service.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.request.EspSdkReq;

import java.util.List;

/**
 * @description:
 * @author: dongwh
 * @date: 2021/10/19 15:44
 */
public interface IEspClient {

    /**
     * 获取esp返回的运营单元信息
     *
     * @param tenantId
     * @param productName
     * @return
     */
    List<EocDto> getDispatchEoc(String tenantId, String productName);

    /**
     * 调用esp同步方法获取地端变化数据
     *
     * @param reqParam
     * @return
     * @throws Exception
     */
    ResponseModel invokeRestSync(EspSdkReq reqParam) throws Exception;

    /**
     * 返回response_objects数组的第一个元素信息，包含：change_objects 和 meta_info
     *
     * @param espRequest
     * @return
     */
    ResultDto<JSONObject> getChangeDataAndMetaInfo(EspSdkReq espRequest);

    /**
     * 返回change_objects节点信息
     *
     * @param espRequest
     * @return
     */
    ResultDto<JSONArray> getChangeObjects(EspSdkReq espRequest);
}
