package com.digiwin.athena.cdme.service.facade.detection.execution.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.ExecuteRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.execution.IPrepareExecutionService;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/4 14:06
 */
@Service("cdmePrepareExecutionService")
public class PrepareExecutionService implements IPrepareExecutionService {

    @Override
    public ResultDto<Map<String, JSONObject>> buildExecutionParam(ExecuteRequestDto executeRequest) {
        MonitorRuleModel ruleModel = executeRequest.getRuleModel();
        /** 动态解析dynamic_params节点信息 */
        JSONObject ruleObj = JsonUtil.getObject(executeRequest.getRuleModel().getMonitorRule());
        Map<String, JSONObject> allParams = new HashMap<>();
        if (executeRequest.getTimeRange() != null) {
            /** 拼接调用执行发起侦测的入参结构 此处需要计算动态参数,然后丢入具体的执行map中传入下去 */
            Map<String, JSONObject> dynamicParams = MonitorHelper.parseDynamicParams(ruleObj, "cdme"+ruleModel.getCategory(), executeRequest.getTimeRange());
            allParams.putAll(dynamicParams);
        }
        /** 获取对应的静态参数结果 */
        Map<String, JSONObject> staticParams = MonitorHelper.parseStaticParams(ruleObj, ruleModel.getCategory());
        /** 将所有参数组装在一起处理 */
        allParams.putAll(staticParams);
        return ResultHelper.generateResult(true, "", allParams);
    }
}
