package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.constant.MqttConstant;
import com.digiwin.athena.cdme.core.enums.Category;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.ISyncFacadeService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import static com.digiwin.athena.cdme.constant.FieldValConstant.*;

/**
 * @description: 修改侦测规则
 * @author: dongwh
 * @date: 2021/10/20 14:27
 */
@Service(FieldValConstant.MONITOR_RULE_MODIFIED)
public class ModifyService implements ISyncFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifyService.class);

    private final IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;

    private final IThemeMapClient themeMapClient;

    public ModifyService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService,
                         IScheduleClient scheduleClient, IThemeMapClient themeMapClient) {
        this.ruleTriggerOperatorFacadeService = ruleTriggerOperatorFacadeService;
        this.themeMapClient = themeMapClient;
    }

    @Override
    @Transactional(value = "dw-transactionManager")
    public ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto) {
        LOGGER.info("修改CDC侦测规则入参:{}", ruleDto);
        MonitorCdcRuleDto monitorRuleDtoOld = ruleTriggerOperatorFacadeService.getByRuleIdAndTenantIdAndEocUnStatus(ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getEocMap());
            ResultDto validResult = validRuleExists(monitorRuleDtoOld);
            if (MonitorHelper.isResultFail(validResult)) {
                return validResult;
            }
        if (Category.CDC.toString().equals(monitorRuleDtoOld.getRuleModel().getCategory())) {
            if (monitorRuleDtoOld.getRuleModel() != null &&
                    StringUtils.equals(monitorRuleDtoOld.getRuleModel().getValid(),RULE_DISABLE)) {
                return ResultHelper.generateFailResult(ErrorCodeEnum.RULE_NOT_EXISTS);
            }
        }
        /** 获取thememap中的侦测规则定义 */
        MonitorCdcRuleDto monitorCdcRuleDto = themeMapClient.getCdcRuleInfo(ruleDto.getTenantId(), ruleDto.getEocMap(), ruleDto.getRuleId());
        MonitorRuleCdcModel currentRule = monitorCdcRuleDto.getRuleModel();
        if (Category.MQTT.toString().equals(monitorRuleDtoOld.getRuleModel().getCategory())) {
            if(StringUtils.equals(ruleDto.getEnableStatus(),"Y")){
                currentRule.setValid(RULE_ENABLE);
            }else if(StringUtils.equals(ruleDto.getEnableStatus(),"N")){
                currentRule.setValid(RULE_DISABLE);
            }
            // MQTT侦测主题和主题来源不允许修改
            if (!(monitorRuleDtoOld.getRuleModel().getDbName().equals(currentRule.getDbName()) && monitorRuleDtoOld.getRuleModel().getTableName().equals(currentRule.getTableName()))) {
                throw new BusinessException("MQTT侦测的主题和主题来源不允许修改");
            }
        }
        processRuleModel(currentRule, monitorRuleDtoOld);
        ruleTriggerOperatorFacadeService.modifyCdcRule(monitorCdcRuleDto);
        LOGGER.info("修改CDC侦测规则成功");
        return ResultHelper.generateResult(ResultEnum.RULE_SCHEDULE_SUCCESS);
    }

    private void processRuleModel(MonitorRuleCdcModel currentRule, MonitorCdcRuleDto monitorRuleDtoOld) {
        currentRule.setKid(monitorRuleDtoOld.getRuleModel().getKid());
        currentRule.setUpdateTime(LocalTimeUtil.now());
    }
}
