/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.mq.consumer.monitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.mq.producer.MessageProducer;
import com.digiwin.athena.cdme.repository.model.MonitorCdcTopicRouteModel;
import com.digiwin.athena.cdme.service.client.IRouterClient;
import com.digiwin.athena.cdme.service.facade.auth.IContextFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorCdcTopicRouteService;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component(value="cdmeMonitorTransferCdcListener")
public class MonitorTransferCdcListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTransferCdcListener.class);
    private final MessageProducer producer;
    private IMonitorCdcTopicRouteService cdcTopicRouteService;
    private final ICacheService redisService;
    private final IRouterClient routerClient;
    private final IContextFacadeService contextService;

    public MonitorTransferCdcListener(IMonitorCdcTopicRouteService cdcTopicRouteService, ICacheService redisService, MessageProducer producer, IRouterClient routerClient, IContextFacadeService contextService) {
        this.cdcTopicRouteService = cdcTopicRouteService;
        this.producer = producer;
        this.redisService = redisService;
        this.routerClient = routerClient;
        this.contextService = contextService;
    }

    @KafkaListener(topics={"PRIVATE_0_CDC"}, groupId="CDME", containerFactory="kafkaListenerContainerFactory", errorHandler="cdmeConsumerAwareErrorHandler")
    public void consumeMonitorMsg(ConsumerRecord<?, ?> record, Acknowledgment ack) throws Exception {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u63a5\u6536CDC\u7684\u8f6c\u53d1\u6d88\u606f\u6765\u81ea\u79c1\u6709\u53160 Topic\u4e3a:[{}]", record.value());
        if (!ConfigConstant.PRIVATIZATION) {
            LOGGER.info("\u975e\u79c1\u6709\u5316\u90e8\u7f72\uff0c\u4e0d\u5904\u7406===========\u300b");
            ack.acknowledge();
            return;
        }
        JSONObject recordJsonObject = JSON.parseObject((String)String.valueOf(record.value()));
        String redisKey = MonitorHelper.buildCdcTopicRouteKey("PRIVATE_0_CDC", "CDME");
        if (this.redisService.hasKey(redisKey)) {
            recordJsonObject.put("tenantId", this.redisService.get(redisKey));
        } else {
            MonitorCdcTopicRouteModel cdcTopicRouteModel = this.cdcTopicRouteService.getByTopicAndGroup("PRIVATE_0_CDC", "CDME");
            if (null == cdcTopicRouteModel) {
                LOGGER.error("\u672a\u914d\u7f6e\u79df\u6237\u548cTopic\u7684\u5173\u7cfb\uff0ctopic={}, group={}", (Object)"PRIVATE_0_CDC", (Object)"CDME");
            } else {
                recordJsonObject.put("tenantId", (Object)cdcTopicRouteModel.getTenantId());
                this.redisService.set(redisKey, cdcTopicRouteModel.getTenantId());
            }
        }
        String tenantId = recordJsonObject.getString("tenantId");
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            try {
                this.contextService.constructContext(tenantId);
                this.routerClient.deliver(JSON.toJSONString((Object)recordJsonObject), tenantId);
            }
            catch (Throwable e) {
                LOGGER.error("\u5904\u7406\u79c1\u6709\u53160\u7684\u6d88\u606f\u6784\u5efa\u4e0a\u4e0b\u6587\u5931\u8d25\uff0ctenantId={}\uff0c\u5f02\u5e38:[{}]", (Object)recordJsonObject.getString("tenantId"), (Object)e);
                throw e;
            }
        }
        ack.acknowledge();
    }
}

