/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.cdme.core.aop.RouterKey;
import com.digiwin.athena.cdme.core.util.SecurityUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.provider.IOptRedisService;
import com.digiwin.athena.cdme.repository.model.MonitorDupModel;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorDupService;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cdmeRedisOperationService")
public class RedisOperationService
implements IOptRedisService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisOperationService.class);
    private static final String NO_ACCESS_OPERATOR_REDIS = "\u65e0\u6743\u9650\u64cd\u4f5credis";
    @Autowired
    private IMonitorDupService monitorDupService;
    @Autowired
    private ICacheService redisService;
    @Autowired
    private IIamClient iamClient;

    @Override
    @RouterKey
    public String postCleanCache(Map<String, Object> param) {
        LOGGER.info("\u64cd\u4f5cpostCleanCache\u7684\u5165\u53c2[{}]", param);
        if (!SecurityUtil.isEnvValid((String)param.get("secure"), "RedisOperationService")) {
            return NO_ACCESS_OPERATOR_REDIS;
        }
        return this.cleanRedisByKey(param);
    }

    private String cleanRedisByKey(Map<String, Object> param) {
        String key = (String)param.get("key");
        if (!this.redisService.hasKey(key)) {
            return "\u5f53\u524dkey\u503c\u4e0d\u5b58\u5728\uff01";
        }
        JSONArray value = (JSONArray)this.redisService.get(key);
        LOGGER.info("\u64cd\u4f5c\u524dkey:({}), value:({})", (Object)key, (Object)value);
        this.redisService.set(key, new JSONArray());
        try {
            this.updateDupModelByCondition(key, new JSONArray().toString());
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u6e05\u9664DB\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01", (Throwable)e);
            this.redisService.set(key, value);
            return "\u6e05\u9664\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01";
        }
        return this.redisService.get(key).toString();
    }

    @Override
    @RouterKey
    public String postReadCache(Map<String, Object> param) {
        LOGGER.info("\u64cd\u4f5cpostReadCache\u7684\u5165\u53c2[{}]", param);
        if (!SecurityUtil.isEnvValid((String)param.get("secure"), "RedisOperationService")) {
            return NO_ACCESS_OPERATOR_REDIS;
        }
        return this.readRedis(param);
    }

    private String readRedis(Map<String, Object> param) {
        String key = (String)param.get("key");
        if (!this.redisService.hasKey(key)) {
            return "Key:[" + key + "] in redis is not found!";
        }
        String result = this.redisService.get(key).toString();
        LOGGER.info("\u64cd\u4f5cpostReadCache\u7684key:({}),\u7ed3\u679c\u662f[{}]", (Object)key, (Object)result);
        return result;
    }

    @Override
    @RouterKey
    public String postSetCache(Map<String, Object> param) {
        LOGGER.info("\u64cd\u4f5cpostSetCache\u7684\u5165\u53c2[{}]", param);
        if (!SecurityUtil.isEnvValid((String)param.get("secure"), "RedisOperationService")) {
            return NO_ACCESS_OPERATOR_REDIS;
        }
        return this.setRedisByKey(param);
    }

    private String setRedisByKey(Map<String, Object> param) {
        JSONArray newCache;
        String key = (String)param.get("key");
        if (!this.redisService.hasKey(key)) {
            return "\u5f53\u524dkey\u503c\u4e0d\u5b58\u5728\uff01";
        }
        if (StringUtil.isBlank((String)param.get("value"))) {
            return "\u66f4\u65b0\u7684\u7f13\u5b58\u503c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            newCache = JSON.parseArray((String)((String)param.get("value")));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6redis\u66f4\u65b0\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return "\u66f4\u65b0\u7f13\u5b58\u503c\u6570\u636e\u683c\u5f0f\u4e0d\u5c5e\u4e8eJSONArray\u683c\u5f0f\uff0c\u8bf7\u67e5\u770b\uff01";
        }
        JSONArray oldCache = (JSONArray)this.redisService.get(key);
        LOGGER.info("\u64cd\u4f5c\u524dkey:({}), value:({})", (Object)key, (Object)oldCache);
        this.redisService.set(key, newCache);
        try {
            this.updateDupModelByCondition(key, newCache.toString());
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u66f4\u65b0DB\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01", (Throwable)e);
            this.redisService.set(key, oldCache);
            return "\u66f4\u65b0\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\uff01";
        }
        String result = this.redisService.get(key).toString();
        LOGGER.info("\u64cd\u4f5cpostSetCache\u7684key:({}),\u7ed3\u679c\u662f[{}]", (Object)key, (Object)result);
        return result;
    }

    private void updateDupModelByCondition(String redisKey, String cacheValue) {
        String[] splitStr = redisKey.split("-");
        MonitorDupModel dupModel = new MonitorDupModel(splitStr[1], splitStr[2], splitStr[3], splitStr[4], splitStr[5], cacheValue);
        this.monitorDupService.editByRuleIdAndTenantIdAndProdAndEocmap(dupModel);
    }

    @Override
    @RouterKey
    public String postCleanCache(Map<String, Object> param, String tenantId) {
        LOGGER.info("\u64cd\u4f5cpostCleanCache\u7684\u5165\u53c2[param:{}\uff0cTenantId:{}]", param, (Object)tenantId);
        if (StringUtil.isBlank(tenantId)) {
            return "\u79df\u6237Id\u4e3a\u7a7a!";
        }
        boolean isTestTenant = this.iamClient.isTest(tenantId);
        if (!isTestTenant) {
            return "\u975e\u6d4b\u8bd5\u79df\u6237,\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c\uff01";
        }
        return this.cleanRedisByKey(param);
    }

    @Override
    @RouterKey
    public String postReadCache(Map<String, Object> param, String tenantId) {
        LOGGER.info("\u64cd\u4f5cpostReadCache\u7684\u5165\u53c2[param:{}\uff0cTenantId:{}]", param, (Object)tenantId);
        if (StringUtil.isBlank(tenantId)) {
            return "\u79df\u6237Id\u4e3a\u7a7a!";
        }
        boolean isTestTenant = this.iamClient.isTest(tenantId);
        if (!isTestTenant) {
            return "\u975e\u6d4b\u8bd5\u79df\u6237,\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c\uff01";
        }
        return this.readRedis(param);
    }

    @Override
    @RouterKey
    public String postSetCache(Map<String, Object> param, String tenantId) {
        LOGGER.info("\u64cd\u4f5cpostSetCache\u7684\u5165\u53c2[param:{}\uff0cTenantId:{}]", param, (Object)tenantId);
        if (StringUtil.isBlank(tenantId)) {
            return "\u79df\u6237Id\u4e3a\u7a7a!";
        }
        boolean isTestTenant = this.iamClient.isTest(tenantId);
        if (!isTestTenant) {
            return "\u975e\u6d4b\u8bd5\u79df\u6237,\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c\uff01";
        }
        return this.setRedisByKey(param);
    }

    @Override
    @RouterKey
    public String postReadRuleCache(Map<String, Object> param) {
        LOGGER.info("\u64cd\u4f5cpostReadRuleCache\u7684\u5165\u53c2[{}]", param);
        if (!SecurityUtil.isEnvValid((String)param.get("secure"), "RedisOperationService")) {
            return NO_ACCESS_OPERATOR_REDIS;
        }
        String key = (String)param.get("key");
        if (!this.redisService.hasKey(key)) {
            return "Key:[" + key + "] in redis is not found!";
        }
        Map<Object, Object> cdcRuleList = this.redisService.hGetAll(key);
        String result = JSON.toJSONString(cdcRuleList);
        LOGGER.info("\u64cd\u4f5cpostReadCache\u7684key:({}),\u7ed3\u679c\u662f[{}]", (Object)key, (Object)result);
        return result;
    }

    @Override
    @RouterKey
    public String postCleanRuleCache(Map<String, Object> param) {
        LOGGER.info("\u64cd\u4f5cpostCleanRuleCache\u7684\u5165\u53c2[{}]", param);
        if (!SecurityUtil.isEnvValid((String)param.get("secure"), "RedisOperationService")) {
            return NO_ACCESS_OPERATOR_REDIS;
        }
        String key = (String)param.get("key");
        if (StringUtils.isNotEmpty((CharSequence)key) && key.substring(0, "cdme-cdc".length()).equals("cdme-cdc")) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(key);
            this.redisService.delete(list);
        }
        return "success";
    }
}

