/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.pojo.dto.DetectionRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.data.IProcessDetectionService;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="cdmeDetectionFacdeProxy")
public class DetectionFacdeProxy {
    private final Map<String, IProcessDetectionService> detectionServiceMap;

    public DetectionFacdeProxy(Map<String, IProcessDetectionService> detectionServiceMap) {
        this.detectionServiceMap = detectionServiceMap;
    }

    public ResultDto<JSONArray> processDetection(Map<String, JSONObject> allParam, DetectionRequestDto requestDto) {
        MonitorRuleModel ruleModel = requestDto.getRuleModel();
        IProcessDetectionService detectionService = this.detectionServiceMap.get("cdme" + ruleModel.getCategory());
        if (null == detectionService) {
            throw new BusinessException(ErrorCodeEnum.UNKONW_CATEGORY);
        }
        return detectionService.processDetection(allParam, requestDto);
    }
}

