/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.pojo.dto.DetectionRequestDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.IEspClient;
import com.digiwin.athena.cdme.service.client.request.EspSdkReq;
import com.digiwin.athena.cdme.service.facade.detection.data.IProcessDetectionService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeSQL_SCRIPT")
public class SqlScriptDetectionService
implements IProcessDetectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlScriptDetectionService.class);
    private final IEspClient espClient;

    public SqlScriptDetectionService(IEspClient espClient) {
        this.espClient = espClient;
    }

    @Override
    public ResultDto<JSONArray> processDetection(Map<String, JSONObject> allParam, DetectionRequestDto requestDto) {
        EspSdkReq sqlScriptParam = this.buildSqlScriptParam(allParam, requestDto.getRuleModel(), requestDto.getEoc());
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ESP\u5f00\u59cb*************");
        ResultDto<JSONArray> scanResult = this.espClient.getChangeObjects(sqlScriptParam);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528ESP\u7ed3\u675f*************");
        return scanResult;
    }

    private EspSdkReq buildSqlScriptParam(Map<String, JSONObject> allParam, MonitorRuleModel ruleInfo, EocDto eocDto) {
        JSONArray dynamicCondition = MonitorHelper.transformToDynamicCondition(allParam);
        JSONObject monitorRule = JsonUtil.getObject(ruleInfo.getMonitorRule());
        return MonitorHelper.buildDataChangeSqlGetRequest(ruleInfo.getRuleId(), ruleInfo.getTenantId(), ruleInfo.getProductName(), dynamicCondition, monitorRule, eocDto);
    }
}

