/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.ISyncFacadeService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cdmeDELETED")
public class DeleteService
implements ISyncFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteService.class);
    private final IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;
    private final IMonitorRuleCdcService monitorRuleCdcService;

    public DeleteService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IMonitorRuleCdcService monitorRuleCdcService) {
        this.ruleTriggerOperatorFacadeService = ruleTriggerOperatorFacadeService;
        this.monitorRuleCdcService = monitorRuleCdcService;
    }

    @Override
    @Transactional(value="cdmeTransactionManager")
    public ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto) {
        LOGGER.info("\u5220\u9664CDC\u4fa6\u6d4b\u89c4\u5219\u5165\u53c2: {}", (Object)ruleDto);
        if (StringUtils.isEmpty((CharSequence)ruleDto.getRuleId()) || StringUtils.isEmpty((CharSequence)ruleDto.getTenantId())) {
            LOGGER.error("\u5220\u9664CDC\u4fa6\u6d4b\u89c4\u5219\u7684\u4fa6\u6d4b\u4ee3\u53f7\u6216\u8005\u79df\u6237ID\u4e3a\u7a7a");
            return ResultHelper.generateResult(true, "");
        }
        MonitorCdcRuleDto monitorCdcRuleDto = new MonitorCdcRuleDto();
        MonitorRuleCdcModel ruleModel = this.monitorRuleCdcService.queryCdcRuleDetailByRuleIdAndTenantId(ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getEocMap());
        monitorCdcRuleDto.setRuleModel(ruleModel);
        ResultDto<Void> validResult = this.validRuleExists(monitorCdcRuleDto);
        if (MonitorHelper.isResultFail(validResult)) {
            return validResult;
        }
        this.ruleTriggerOperatorFacadeService.deleteCdcRule(monitorCdcRuleDto, ruleDto.getEocMap());
        LOGGER.info("\u5220\u9664CDC\u4fa6\u6d4b\u89c4\u5219\u6210\u529f");
        return ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage());
    }
}

