/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.RuleExtensionDto;
import com.digiwin.athena.cdme.repository.model.MonitorOptRecordModel;
import com.digiwin.athena.cdme.service.facade.rulesync.IRuleExtensionEventService;
import com.digiwin.athena.cdme.service.facade.rulesync.IRuleExtensionService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorOptRecordService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeRuleExtensionService")
public class RuleExtensionService
implements IRuleExtensionService {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleExtensionService.class);
    private final Map<String, IRuleExtensionEventService> eventMap;
    private final IMonitorOptRecordService monitorOptRecordService;

    public RuleExtensionService(Map<String, IRuleExtensionEventService> eventMap, IMonitorOptRecordService monitorOptRecordService) {
        this.eventMap = eventMap;
        this.monitorOptRecordService = monitorOptRecordService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultDto<Void> execute(MonitorRuleDto ruleDto) {
        if (null == ruleDto.getExtensionDto() || CollectionUtil.isEmpty(ruleDto.getExtensionDto().getEvents())) {
            return ResultHelper.generateSuccessResult(null);
        }
        MonitorOptRecordModel optRecordModel = new MonitorOptRecordModel(ruleDto.getTenantId(), ruleDto.getRuleId(), "RULE_EXTENSION_OP", ruleDto.getRuleEoc(), JsonUtil.getJsonString(ruleDto.getExtensionDto()));
        try {
            LOGGER.info("ruleId:{},tenantId:{},eoc:{}, \u5904\u7406\u89c4\u5219\u6269\u5c55\u914d\u7f6e", new Object[]{ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getRuleEoc()});
            List<RuleExtensionDto.Event> events = ruleDto.getExtensionDto().getEvents();
            ArrayList<String> errMsg = new ArrayList<String>();
            for (RuleExtensionDto.Event event : events) {
                IRuleExtensionEventService eventService = this.eventMap.get("cdme" + event.getEventType());
                if (null == eventService) {
                    errMsg.add("\u672a\u77e5\u7684\u4e8b\u4ef6" + event.getEventType());
                    continue;
                }
                ResultDto<Void> eventRs = eventService.handle(event, ruleDto);
                if (!MonitorHelper.isResultFail(eventRs)) continue;
                errMsg.add(event.getEventType() + "\u5904\u7406\u5931\u8d25\uff1a" + eventRs.getMessage());
            }
            if (CollectionUtil.isEmpty(errMsg)) {
                optRecordModel.setStatus(1);
                ResultDto<Object> resultDto = ResultHelper.generateSuccessResult(null);
                return resultDto;
            }
            String msg = StringUtils.join(errMsg, (String)";");
            LOGGER.error("ruleId:{},tenantId:{},eoc:{},\u5904\u7406\u89c4\u5219\u6269\u5c55\u914d\u7f6e\u5931\u8d25:{}", new Object[]{ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getRuleEoc(), msg});
            ResultDto<Void> resultDto = ResultHelper.generateFailResult(ErrorCodeEnum.AFTER_CREATE_EVENT_ERR, new Void[0]);
            return resultDto;
        }
        catch (Exception e) {
            LOGGER.error("ruleId:{},tenantId:{},eoc:{},\u5904\u7406\u89c4\u5219\u6269\u5c55\u914d\u7f6e\u5f02\u5e38", new Object[]{ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getRuleEoc(), e});
            ResultDto<Void> resultDto = ResultHelper.generateFailResult(ErrorCodeEnum.AFTER_CREATE_EVENT_ERR, new Void[0]);
            return resultDto;
        }
        finally {
            this.monitorOptRecordService.save(optRecordModel);
        }
    }
}

