package com.digiwin.athena.datamap.actions.handlers;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.supports.EspRequest;
import io.seata.common.util.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

/**
 * @title: Esp_bm_iisc_item_general_get
 * @author: linc
 * @date 2023/11/9 13:12
 * @version: 1.0
 */
@Service
@Order(10)
public class Esp_bm_iisc_item_general_get extends AbstractActionHandler {

    @Override
    public String actionId() {
        return "esp_" + ActionConstants.bm_iisc_item_general_get;
    }

    @Override
    public String description() {
        return "APC物料开窗后端分页";
    }

    @Override
    public ActionResp handler(ActionContext context) {
        Map<String, Object> params = context.getActionReq().getParams();
        Object searchValue = params.get("search_value");
        if (Objects.nonNull(searchValue) && StringUtils.isNotEmpty(searchValue.toString())) {
            String json = "{\"search_info\": [{\"order\": 1,\"search_field\": \"item_no\",\"search_operator\": \"like\",\"search_value\": ['" + searchValue
                    + "'],\"logic\": \"or\"},{\"logic\": \"or\",\"order\": 2,\"search_field\": \"item_name\",\"search_operator\": \"like\",\"search_value\": ['" + searchValue
                    + "']},{\"order\": 3,\"search_field\": \"item_spec\",\"search_operator\": \"like\",\"search_value\": ['" + searchValue + "']}]}";
            // 将JSON字符串转换为Map对象
            Map<String, Object> jsonMap = JSON.parseObject(json);
            // 将jsonMap中的键值对添加到params中
            params.putAll(jsonMap);
        }
        params.remove("search_value");

        EspRequest request = EspRequest.of(context.getActionReq().getServiceName(), context.getActionReq().getProduct(), params, super.E10headers());
        request.setHostProd("EAS");
        return callEsp(request);
    }
}
