package com.digiwin.athena.datamap.engine.service.check;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.engine.service.utils.ScriptEngineUtil;
import lombok.extern.slf4j.Slf4j;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-05-30 18:04
 **/
@Service
@Slf4j
public class ExpressionCheckHandler implements MechanismCheckHandler {

    @Override
    public boolean accept(CheckWidget condition) {
        return "expression".equalsIgnoreCase(condition.getType());
    }

    @Override
    public boolean check(CheckWidget condition, Map obj) {

        try {
            String expression = condition.getExpression();
            boolean checkResult = executeConditionEvaluator(expression, obj);
            return checkResult;
        } catch (Exception e) {
            log.error(e.toString());
        }

        return false;
    }

    public static boolean executeConditionEvaluator(String conditionScript, Map<String, Object> mergedVariables) throws DWBusinessException {
        String script = "";
        script = script + " if(" + conditionScript + "){  \n";
        script = script + "  return true;\n";
        script = script + " }else {  \n";
        script = script + "  return false;  \n";
        script = script + " } \n";

        return (Boolean) ScriptEngineUtil.getInstance().executeScript(script, mergedVariables);
    }

    public static void main(String[] args) throws DWBusinessException {
        Map<String, Object> data1 = new HashMap<>();
        data1.put("doc_no", "doc01");
        data1.put("doc_name", "请购单1");
        data1.put("type", 0);
        Map<String, Object> param = new HashMap<>();
        param.put("item", data1);
        boolean res = executeConditionEvaluator("(($(item).type==0)  && ($(item).doc_no=='doc01')) ", param);
        System.out.println(res);
    }
}
