package com.digiwin.athena.datamap.engine.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.engine.service.IMechanismEngine;
import com.digiwin.athena.datamap.engine.service.processor.MechDatasourceProcessor;
import com.digiwin.athena.mechanism.dto.SourceDataDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-14 16:05
 **/
@Service
public class MechanismEngine implements IMechanismEngine {

    @Autowired
    List<MechDatasourceProcessor> processors;

    @Override
    public Object OnData(SourceDataDTO datasource) throws DWException {

        for (MechDatasourceProcessor processor : processors) {
            if (processor.accept(datasource)) {
                return processor.process(datasource);
            }
        }
        return null;
    }
}
