/**
 * FileName: ScriptEngineUtil
 * Author:   DONGSK
 * Datetime: 2020/7/25 13:19
 * Description: JS 脚本引擎工具
 * History:
 * 作者姓名 --修改时间 --版本号--描述
 */
package com.digiwin.athena.datamap.engine.service.utils;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

import javax.script.*;
import java.util.*;

/**
 * ScriptEngineUtil
 * JS 脚本引擎工具
 *
 * @author DONGSK
 * @date 2020/7/25
 * @since 1.0.0
 */
public class ScriptEngineUtil {

    private static class ScriptEngineHolder {

        private static final ScriptEngineUtil INSTANCE = new ScriptEngineUtil();
    }

    private ScriptEngineManager factory = new ScriptEngineManager();

    private ScriptEngine engine = factory.getEngineByName("nashorn");

    private ScriptEngineUtil() {
    }

    public static ScriptEngineUtil getInstance() {
        return ScriptEngineHolder.INSTANCE;
    }

    public ScriptContext execute(String scriptString) throws DWBusinessException {
        ScriptContext ctx = new SimpleScriptContext();
        ctx.setBindings(engine.createBindings(), ScriptContext.ENGINE_SCOPE);
        try {
            engine.eval(scriptString, ctx);
        } catch (ScriptException e) {
            throw new DWBusinessException(I18nUtils.getValue("datamap.scriptError") + "\n" + scriptString + "\n", e);
        }
        return ctx;
    }

    public Object executeScript(String scriptString, String resultName) throws DWBusinessException {
        return convert(execute(scriptString).getAttribute(resultName));
    }

    public Object executeScript(String scriptString) throws DWBusinessException {
        String exeScriptString = String.format("function execute(){ \n %s" +
                "\n }; \n" +
                "var __executeResult = execute();", scriptString);
        return this.executeScript(exeScriptString, "__executeResult");
    }

    public String executeStringify(String scriptString) throws DWBusinessException {
        String exeScriptString = String.format("function execute(){ \n %s" +
                "\n }; \n" +
                "var __executeResult= JSON.stringify(execute());", scriptString);
        return (String) execute(exeScriptString).getAttribute("__executeResult");
    }

    public Object executeScript(String scriptString, Map<String, Object> pMergedVariables) throws DWBusinessException {

        String script = ProjectVariableUtil.parseContext(scriptString, pMergedVariables);

        return executeScript(script);
    }

    public String executeStringify(String scriptString, Map<String, Object> pMergedVariables) throws DWBusinessException {

        @SuppressWarnings("unchecked")
        String script = ProjectVariableUtil.parseContext(scriptString, pMergedVariables);

        return executeStringify(script);
    }

    public boolean executeConditionEvaluator(String conditionScript, Map<String, Object> pMergedVariables) throws DWBusinessException {
        String script = "";
        script = script + " if(" + conditionScript + "){  \n";
        script = script + "  return true;\n";
        script = script + " }else {  \n";
        script = script + "  return false;  \n";
        script = script + " } \n";

        // script = ProjectVariableUtil.parseContextByVarType(script, pMergedVariables);

        return (Boolean) this.executeScript(script, pMergedVariables);
    }

    public static Object convert(Object original) {
        if (original == null) {
            return null;
        } else if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Boolean || original instanceof Double) {
            return original;
        } else if (original instanceof ScriptObjectMirror) {
            ScriptObjectMirror jsOriginal = (ScriptObjectMirror) original;
            if (jsOriginal.isArray()) {
                List<Object> listResult = new ArrayList<Object>();
                Integer length = (Integer) jsOriginal.get("length");
                for (int i = 0; i < length; i++) {
                    listResult.add(convert(jsOriginal.get("" + i)));
                }
                return listResult;
            } else if (jsOriginal.isFunction()) {
                // can't convert it...
                return null;
            }
            Map<String, Object> mapResult = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : jsOriginal.entrySet()) {
                mapResult.put(entry.getKey(), convert(entry.getValue()));
            }
            return mapResult;
        }
        return original;
    }

    public static void main(String[] args) throws DWBusinessException {

        Map<String, Object> data1 = new HashMap<>();
        data1.put("doc_no", "doc01");
        data1.put("slow_down_days", "1");
        data1.put("doc_name", "请购单1");
        data1.put("type", 0);
        Map<String, Object> param = new HashMap<>();
        param.put("item", data1);
        boolean res = ScriptEngineUtil.getInstance().executeConditionEvaluator("(($(item).type==0)  && ($(item).doc_no=='doc01')) ", param);
        System.out.println(res);

        boolean res2 = ScriptEngineUtil.getInstance().executeConditionEvaluator("$(item).slow_down_days == '1'", param);
        System.out.println(res2);
    }
}
