package com.digiwin.athena.datamap.kg;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Repository
public class DataMapMongoEntityBaseDAO {
    @Autowired
    @Qualifier("kgSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    KmService kmService;

    private String DEFAULT_TENANT_ID = "SYSTEM";

    public <T extends TenantObject> T findOne(Map<String, Object> keyConditions, Class<T> c) throws DWBusinessException {
        return findOne(keyConditions, kmService.tenantVersion(), c);
    }

    public <T extends TenantObject> T findOne(Map<String, Object> keyConditions, String tenantVersion, Class<T> c) throws DWBusinessException {
        return findOne(keyConditions, tenantVersion, c, null);
    }
    public <T extends TenantObject> T findOne(Map<String, Object> keyConditions, String tenantVersion, Class<T> c, String collectionName) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List<String> tenantIds = new ArrayList<>();
        tenantIds.add(tenantId);
        if(!DEFAULT_TENANT_ID.equals(tenantId)){
            tenantIds.add(DEFAULT_TENANT_ID);
            //兼容未设定租户的数据，预设为系统级数据
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value)-> {
            criteria.and(key).is(value);
        });

        List<T> queryResults = collectionName == null ?
                mongoTemplate.find(Query.query(criteria.and("tenantId").in(tenantIds).and("version").is(tenantVersion)),c):
                mongoTemplate.find(Query.query(criteria.and("tenantId").in(tenantIds).and("version").is(tenantVersion)),c, collectionName);
        //优先返回租户级的配置
        for (T result : queryResults) {
            if (!DEFAULT_TENANT_ID.equals(result.getTenantId()) && result.getTenantId() != null) {
                return result;
            }
        }
        //否则返回第一个非租户级配置
        if (queryResults.size() > 0) {
            return queryResults.get(0);
        }
        return null;
    }

    public <T extends TenantObject> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, Class<T> c, Map<String, Activity> activityMap) throws DWBusinessException {
        return find(keyConditions, listKey, list, kmService.tenantVersion(), c,activityMap);
    }

    public <T extends TenantObject> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, String tenantVersion, Class<T> c, Map<String, Activity> activityMap) throws DWBusinessException {
        return find(keyConditions, listKey, list, tenantVersion, c,null, activityMap);
    }

    public <T extends TenantObject> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, String tenantVersion, Class<T> c, String collectionName, Map<String, Activity> activityMap) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List<String> tenantIds = new ArrayList<>();
        tenantIds.add(tenantId);
        if (!DEFAULT_TENANT_ID.equals(tenantId)) {
            tenantIds.add(DEFAULT_TENANT_ID);
            //兼容未设定租户的数据，预设为系统级数据
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value) -> {
            criteria.and(key).is(value);
        });
        criteria.and(listKey).in(list);

        List<T> queryResults = collectionName == null ?
                mongoTemplate.find(Query.query(criteria.and("tenantId").in(tenantIds).and("version").is(tenantVersion)), c) :
                mongoTemplate.find(Query.query(criteria.and("tenantId").in(tenantIds).and("version").is(tenantVersion)), c, collectionName);
        if (CollectionUtils.isEmpty(queryResults)) {
            return new HashMap<>();
        }
        Map<String, List<T>> groupedQueryResults = getGroupedQueryResults(keyConditions, listKey, queryResults, c);
        Map<String, List<T>> result = new HashMap<>();
        groupedQueryResults.forEach((k, v) -> {
            String groupedKey = k.substring(k.lastIndexOf("&") + 1);
            List<T> keyList = CollectionUtils.isEmpty(result.get(groupedKey)) ? new LinkedList<>() : result.get(groupedKey);
            Activity activity = activityMap.get(groupedKey);
            boolean ifCommon = activity != null && "common".equalsIgnoreCase(activity.getAthena_namespace());
            //优先返回租户级的配置
            boolean added = false;
            for (T item : v) {
                if (ifCommon || (!DEFAULT_TENANT_ID.equals(item.getTenantId()) && item.getTenantId() != null)) {
                    keyList.add(item);
                    added = true;
                    if (!ifCommon) {
                        break;
                    }
                }
            }
            //否则返回第一个非租户级配置
            if ((!added) && v.size() > 0) {
                keyList.add(v.get(0));
            }
            result.put(groupedKey, keyList);
        });
        return result;
    }

    public <T extends TenantObject> List<T> find(Map<String, Object> keyConditions, Class<T> c) throws DWBusinessException {
        return find(keyConditions, kmService.tenantVersion(), c);
    }

    public <T extends TenantObject> List<T> find(Map<String, Object> keyConditions, String tenantVersion, Class<T> c) throws DWBusinessException {
        return find(keyConditions, tenantVersion, c, null);
    }
    public <T extends TenantObject> List<T> find(Map<String, Object> keyConditions, String tenantVersion, Class<T> c, String collectionName) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List<String> tenantIds = new ArrayList<>();
        tenantIds.add(tenantId);
        if(!DEFAULT_TENANT_ID.equals(tenantId)){
            tenantIds.add(DEFAULT_TENANT_ID);
            //兼容未设定租户的数据，预设为系统级数据
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value)-> {
            criteria.and(key).is(value);
        });

        List<T> queryResults = collectionName == null ?
                mongoTemplate.find(Query.query(criteria.and("tenantId").in(tenantIds).and("version").is(tenantVersion)),c):
                mongoTemplate.find(Query.query(criteria.and("tenantId").in(tenantIds).and("version").is(tenantVersion)),c, collectionName);
        if (CollectionUtils.isEmpty(queryResults)) {
            return new ArrayList<>();
        }
        Map<String, List<T>> groupedQueryResults = getGroupedQueryResults(keyConditions, queryResults, c);
        List<T> result = new LinkedList<>();
        groupedQueryResults.values().forEach(group -> {
            //优先返回租户级的配置
            boolean added = false;
            for (T item : group) {
                if (!DEFAULT_TENANT_ID.equals(item.getTenantId()) && item.getTenantId() != null) {
                    result.add(item);
                    added = true;
                    break;
                }
            }
            //否则返回第一个非租户级配置
            if ((!added) && group.size() > 0) {
                result.add(group.get(0));
            }
        });
        return result;
    }

    private <T extends TenantObject> Map<String, List<T>> getGroupedQueryResults(Map<String, Object> keyConditions, String listKey, List<T> queryResults, Class<T> c) {
        List<Map> queryResultMapList = JSON.parseArray(JSON.toJSONString(queryResults), Map.class);
        Map<String, List<Map>> groupedQueryResults = queryResultMapList.stream().
                collect(Collectors.groupingBy(e -> buildKey(keyConditions.keySet(), listKey, e)));
        Map<String, List<T>> groupedQueryObjResults = new HashMap<>();
        groupedQueryResults.forEach((k, list) -> groupedQueryObjResults.put(k, JSON.parseArray(JSON.toJSONString(list), c)));
        return groupedQueryObjResults;
    }

    private String buildKey(Collection normalKey, String listKey, Map result) {
        String normalKeyStr = String.valueOf(normalKey.stream().map(item -> String.valueOf(result.get(item))).collect(Collectors.joining("&")));
        return StringUtils.isEmpty(normalKeyStr) ? String.valueOf(result.get(listKey)) : normalKeyStr + "&" + result.get(listKey);
    }

    private <T extends TenantObject> Map<String, List<T>> getGroupedQueryResults(Map<String, Object> keyConditions, List<T> queryResults, Class<T> c) {
        List<Map> queryResultMapList = JSON.parseArray(JSON.toJSONString(queryResults), Map.class);
        Map<String, List<Map>> groupedQueryResults = queryResultMapList.stream().
                collect(Collectors.groupingBy(e -> keyConditions.keySet().stream().map(item -> String.valueOf(e.get(item)))
                        .collect(Collectors.joining("&"))
                ));
        Map<String, List<T>> groupedQueryObjResults = new HashMap<>();
        groupedQueryResults.forEach((k, list) -> groupedQueryObjResults.put(k, JSON.parseArray(JSON.toJSONString(list), c)));
        return groupedQueryObjResults;
    }

}
