package com.digiwin.athena.datamap.mechanism;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.activitybuilder.ActivityBuildService;
import com.digiwin.athena.datamap.mechanism.checkhandlers.CheckHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-06 08:54
 **/
@Service
public class MechanismHelpService {

    @Autowired
    DataMapPickService dataPickService;

    @Autowired
    @Lazy
    List<ActivityBuildService> activityBuildServices;

    @Autowired
    @Lazy
    List<CheckHandler> checkHandlers;

    @Autowired
    PluginService pluginService;

    public void unapplyCommon(BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postRemovePlugin(binding);
    }

    public List<Activity> parseActivity(ActivityWidget ma, MechanismParseContext context) {
        List<Activity> activities = null;
        for (ActivityBuildService buildService : activityBuildServices) {
            if (buildService.accept(ma)) {
                activities = buildService.build(ma, context);
                break;
            }
        }
        if (null == activities) {
            activities = new ArrayList<>();
        }
        return activities;
    }

    public String toExpression(CheckWidget check, MechanismParseContext context) {
        String expression = null;
        if (null == check) {
            return null;
        }
        for (CheckHandler handler : checkHandlers) {
            if (handler.accept(check)) {
                expression = handler.expression(check);
                break;
            }
        }

        expression = replaceMechanismVariable(expression, context, true);
        return expression;
    }

    public String replaceMechanismVariable(String content, MechanismParseContext context, boolean isScript) {
        if (null != content && CollectionUtils.isNotEmpty(context.getBo().getRegisterParams()) && context.getBindingContext().getMechanismVariables().size() > 0) {
            for (String key : context.getBo().getRegisterParams()) {
                String template = "\\$\\(" + key + "\\)";
                Object value = context.getBindingContext().getMechanismVariables().get(key);
                if (null != value) {
                    if (isScript && value instanceof String) {
                        content = content.replaceAll(template, "'" + value.toString() + "'");
                    } else {
                        content = content.replaceAll(template, value.toString());
                    }
                }
            }
        }

        return content;
    }

    public String uid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public <T> T convert(Object obj, Class<T> c) {
        if (null == obj) {
            return null;
        }
        T t = dataPickService.convert(obj, c);
        return t;
    }

    public static void main(String[] args) {
        String str = "aaa$(aa)bbb";
        String template = "\\$\\(aa\\)";
        System.out.println(str.replaceAll(template, "-"));
    }

}
