package com.digiwin.athena.datamap.mechanism.activitybuilder;

import com.alibaba.fastjson.JSON;

import com.digiwin.athena.datamap.enums.NoticeLinkEnum;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.mechanism.dto.ImLinkDTO;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.activity.IMActivityWidget;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.*;

import static com.digiwin.athena.datamap.mechanism.convert.parsers.IMContentParser.parseVariables;

@Service
@Order(1)
@Slf4j
public class IMActivityBuildService extends AbstractActivityBuildService {

    @Value("${athenaUrl}")
    private String athenaUrl;
    @Override
    public boolean accept(ActivityWidget ma) {
        return "im".equalsIgnoreCase(ma.getType());
    }

    @Override
    public void build(ActivityWidget ma, MechanismParseContext context, List<Activity> list) {
        IMActivityWidget imActivityWidget = super.convert(ma, IMActivityWidget.class);

        // 转成DTD中发IM消息的activity
        Activity activity = list.get(0);
        String message = imActivityWidget.getMessage();
        if (StringUtils.isNotBlank(message) && message.contains("\n")) {
            // 兼容消息体内附带换行符，'\\'表示反斜杠字符
            String replaceMessage = imActivityWidget.getMessage().replace("\n", "\\n");
            message = replaceMessage;
            imActivityWidget.setMessage(replaceMessage);
        }
        log.info("imActivityWidget.getSendType:{}", imActivityWidget.getSendType());
        log.info("imActivityWidget.getObjectType:{}", imActivityWidget.getObjectType());
        log.info("imActivityWidget.getUserId():{}", imActivityWidget.getUserId());
        // 构造活动，分为发送模板消息的活动类型和其他类型
        // sendType: groupByBusinessData(按业务字段分发),uniform(统⼀发送)，现在又改成了固定传groupByBusinessData
        // objectType, //对象类型:1：任务 2：api，兼容下历史为空的场景
        String objectType = Optional.ofNullable(imActivityWidget.getObjectType()).orElse("1");
        if (StringUtils.isEmpty(imActivityWidget.getUserId())) {
            if (!message.isEmpty() && ("2".equals(objectType)) || "3".equals(objectType)) {

                // 组装js脚本调用分发服务
                // 这里应该是分组发送并且接收人是从api返参去拿，没有聚合函数处理
                Map<String, Object> config = this.transToIMConfigsApi(imActivityWidget);
                activity.setConfig(config);
                activity.setType("http");
            } else {
                if (imActivityWidget.getPerformerType().equalsIgnoreCase("businessField")) {
                    Map<String, Object> config = this.transToIMConfigsApi(imActivityWidget);
                    activity.setConfig(config);
                    activity.setType("http");
                } else {
                    Map<String, Object> config = this.transToIMTemplateConfig(imActivityWidget);
                    activity.setConfig(config);
                    activity.setType("im"); // 新的活动类型
                    activity.setExecutor(getActivityExecutor(imActivityWidget)); // 设置im活动的执行人
                }
            }
        } else {

            if (!message.isEmpty() && "1".equals(objectType)) {
                if (imActivityWidget.getPerformerType().equalsIgnoreCase("businessField")) {
                    Map<String, Object> config = this.transToIMConfigsApi(imActivityWidget);
                    activity.setConfig(config);
                    activity.setType("http");
                } else {
                    // 组装js脚本调用分发服务
                    Map<String, Object> config = this.transToIMConfig(imActivityWidget);
                    activity.setConfig(config);
                    activity.setType("http");
                }
            } else if (!message.isEmpty() && ("2".equals(objectType) || "3".equals(objectType))) {
                // 组装js脚本调用分发服务
                Map<String, Object> config = this.transToIMConfigsApi(imActivityWidget);
                activity.setConfig(config);
                activity.setType("http");
            }
        }

    }

    private Map<String, Object> transToIMConfig(IMActivityWidget convert) {
        Map<String, Object> config = new HashMap<>();
        config.put("url", "/api/aim/v2/batch/user/message");
        config.put("contentType", "json");
        config.put("executionMode", "script");
        config.put("domain", "aim");
        config.put("method", "post");

        Map<String, Object> headerMap = new HashMap<>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        config.put("headers", headerMap);

        Map<String, Object> scriptModeMap = new HashMap<>();
        scriptModeMap.put("responseScript",
                "var response = $(response);\n" +
                        "var tSuccess = true;\n" +
                        "var tErrorMessage = '';\n" +
                        "if (response['status'] == 200) {\n    " +
                        "tErrorMessage = 'Success';\n} else {\n    tSuccess = false;\n    " +
                        "tErrorMessage = response['statusDescription'];\n}\n" +
                        "return {\n    'success': tSuccess,\n    'errorMessage': tErrorMessage\n};\n");
        scriptModeMap.put("requestScript", this.getRequestScript(convert));

        config.put("scriptMode", scriptModeMap);
        return config;
    }
    private Map<String, Object> transToIMConfigsApi(IMActivityWidget convert) {
        Map<String, Object> config = new HashMap<>();
        config.put("url", "/restful/service/knowledgegraph/mechanismEnhancement/sendNotice");
        config.put("contentType", "json");
        config.put("executionMode", "script");
        config.put("domain", "thememap");
        config.put("method", "post");

        Map<String, Object> headerMap = new HashMap<>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        config.put("headers", headerMap);

        Map<String, Object> scriptModeMap = new HashMap<>();
        scriptModeMap.put("responseScript",
                "var response = $(response);\nvar tSuccess = true;\n" +
                        "var tErrorMessage = '';\n" +
                        "if (response['status'] == 200) {\n    tErrorMessage = 'Success';\n} " +
                        "else {\n    tSuccess = false;\n    tErrorMessage = response['statusDescription'];\n}\n" +
                        "return {\n    'success': tSuccess,\n    'errorMessage': tErrorMessage\n};\n");
        if (CollectionUtils.isNotEmpty(convert.getGroupFields())) {
            // 增加带分组字段的，加个分支不影响php的逻辑
            scriptModeMap.put("requestScript", this.getGroupedIMHandRequestScriptApi(convert));
        } else {
            scriptModeMap.put("requestScript", this.getIMHandRequestScriptApi(convert));
        }

        config.put("scriptMode", scriptModeMap);
        return config;
    }

    private Object getGroupedIMHandRequestScriptApi(IMActivityWidget convert) {
        String message = convert.getMessage();
        if (message.contains("\n")) {
            message = message.replaceAll("\n", "");
        }
        Map<String, String> msgLangMap = processLangAndLinks(convert, message);
        StringBuilder requestScriptSb = new StringBuilder();
        requestScriptSb.append("var tenantId = '$(tenantId)';\n")
                .append("var taskBizDataList = $(taskBizData);\n")
                .append("var processLocale = '$(processLocale)';\n")
                .append("var msg = processLocale === 'zh_TW' ? '" + msgLangMap.get("zh_TW") + "': processLocale === 'en_US' ? '" + msgLangMap.get("en_US") + "':'" + msgLangMap.get("zh_CN") + "';\n")
                .append("var noticeVO = {\n")
                .append("'taskBizData': taskBizDataList,\n")
                .append("'tenantId': tenantId,\n ")
                .append("'message': msg,\n")
                .append("'groupFields': ").append(JSON.toJSONString(convert.getGroupFields())).append(",\n ")
                .append("'userIds': " + convert.getUserId() + ",\n ")
                .append("'businessFields': '" + convert.getPerformerValue() + "'\n ")
                .append("}\n")
                .append("var request = {\n ")
                .append("'noticeVO': noticeVO\n")
                .append("};\n")
                .append("return request;");
        return requestScriptSb.toString();
    }

    private Map<String, Object> transToIMConfigs(IMActivityWidget convert) {
        Map<String, Object> config = new HashMap<>();
        config.put("url", "/restful/service/knowledgegraph/mechanismEnhancement/messageHand");
        config.put("contentType", "json");
        config.put("executionMode", "script");
        config.put("domain", "thememap");
        config.put("method", "post");
        Map<String, Object> headerMap = new HashMap<>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        config.put("headers", headerMap);
        Map<String, Object> scriptModeMap = new HashMap<>();
        scriptModeMap.put("responseScript",
                "var response = $(response);\nvar tSuccess = true;\nvar tErrorMessage = '';\n" +
                        "if (response['status'] == 200) {\n    tErrorMessage = 'Success';\n} " +
                        "else {\n    tSuccess = false;\n    tErrorMessage = response['statusDescription'];\n}\n" +
                        "return {\n    'success': tSuccess,\n    'errorMessage': tErrorMessage\n};\n");
        scriptModeMap.put("requestScript", this.getIMHandRequestScript(convert));
        config.put("scriptMode", scriptModeMap);
        return config;
    }

    private Map<String, Object> transToIMTemplateConfig(IMActivityWidget convert) {
        Map<String, Object> config = new HashMap<>();
        Map<String, Object> scriptModeMap = new HashMap<>();
        scriptModeMap.put("responseScript",
                "var response = $(response);\nvar tSuccess = true;\nvar tErrorMessage = '';\n" +
                        "if (response['status'] == 200) {\n    tErrorMessage = 'Success';\n} " +
                        "else {\n    tSuccess = false;\n    " +
                        "tErrorMessage = response['statusDescription'];\n}\nreturn {\n    'success': tSuccess,\n    'errorMessage': tErrorMessage\n};\n");
        scriptModeMap.put("requestScript", this.getIMTemplateRequestScript(convert));

        config.put("scriptMode", scriptModeMap);

        return config;
    }

    // 构造IM活动的执行人属性
    private UserDefinition getActivityExecutor(IMActivityWidget imActivityWidget) {
        UserDefinition executor = new UserDefinition();
        executor.setChoosePolicy("all");
        List<Identity> identities = new ArrayList<>();
        Identity identity = new Identity();
        if ("taskExecutor".equalsIgnoreCase(imActivityWidget.getPerformerType())) {
            imActivityWidget.setPerformerType("user"); // 下个任务的执行人的类型也是user
        }
        identity.setPerformerType(imActivityWidget.getPerformerType()); // 设置执行人的类型和值
        identity.setPerformerValue(imActivityWidget.getPerformerValue());
        identities.add(identity);
        executor.setIdentities(identities);
        return executor;
    }

    private String getRequestScript(IMActivityWidget convert) {
        String message = convert.getMessage();
        if (message.contains("\n")) {
            message = message.replaceAll("\n", "");
        }
        message = message.replaceAll("\\$(\\w+)\\$", "\\$\\($1\\)"); // 如果是模板消息做查找替换
        message = message.replaceAll("\\$\\{(.+?)}", "\\$($1)"); // 如果是模板消息做查找替换
        String title = convert.getTitle();
        String titleEn = title;
        String titleTW = title;

        Map<String, Map<String, String>> lang = convert.getLang();
        if (lang != null) {
            Map<String, String> langTitle = lang.get("title");
            if (langTitle != null) {
                titleTW = langTitle.getOrDefault("zh_TW", titleTW);
                titleEn = langTitle.getOrDefault("en_US", titleEn);
            }
        }

        StringBuilder requestScriptSb = new StringBuilder();
        String userId = convert.getUserId();
        Map<String, String> msgLangMap = processLangAndLinks(convert, message);
        // 是否需要跳转到任务详情
        boolean jumpTaskDetail = CollectionUtils.isNotEmpty(convert.getLinks()) && convert.getLinks().stream().anyMatch(link -> NoticeLinkEnum.TASK_DETAIL.getType().equals(link.getType()));
        if (StringUtils.isNotEmpty(userId) && (userId.contains("[*]") || jumpTaskDetail)) {
            String userArrayObject = "MECHANISM_PARAMETER".equals(convert.getPerformerType()) ? "$(list)" : userId.substring(0, userId.indexOf("[*]"));
            String userKey = "MECHANISM_PARAMETER".equals(convert.getPerformerType()) ? "" : userId.substring(userId.indexOf("[*]") + 4);

            requestScriptSb.append("var tenantId = '$(tenantId)';\n")
                    .append("var processLocale = '$(processLocale)';\n")
                    .append("var userArrayObject = " + userArrayObject + ";\n")
                    .append("var curDate = new Date();\n")
                    .append("var title = '" + title + "';\n")
                    .append("var msg = '" + msgLangMap.get("zh_CN") + "';\n")
                    .append("if (processLocale === 'zh_TW') {\n")
                    .append("title = '" + titleTW + "';\n")
                    .append("msg = '" + msgLangMap.get("zh_TW") + "';\n}")
                    .append("else if (processLocale === 'en_US') {\n ")
                    .append("title = '" + titleEn + "';\n")
                    .append("msg = '" + msgLangMap.get("en_US") + "';\n}\n")
                    .append("var userIdArray = [];\n") // To track unique user IDs
                    .append(" var request = userArrayObject.map(function (info) {")
                    .append("    var userId = ").append("MECHANISM_PARAMETER".equals(convert.getPerformerType()) ? userId : "[info." + userKey + "]").append(";\n ")
                    .append("    if (!").append(jumpTaskDetail).append(") {\n")
                    .append("        if (userIdArray.indexOf(JSON.stringify(userId))>-1) {\n")
                    .append("            return null;\n")
                    .append("        }\n")
                    .append("        userIdArray.push(JSON.stringify(userId));\n")
                    .append("    }\n")
                    .append(" return {\n")
                    .append("        'userIdList': userId,\n")
                    .append("'tenantId': tenantId,\n")
                    .append("'message': {\n")
                    .append("'sendDate': curDate,\n")
                    .append("'importance': 0,\n")
                    .append("'source': 'athena',\n")
                    .append("'type': 'activity',\n")
                    .append("'title': title,\n")
                    .append("'content': {\n")
                    .append("'msg': msg,\n ")
                    .append("'name': '',\n")
                    .append("'startTime': curDate,\n")
                    .append("'id': ").append(jumpTaskDetail ? "info.backlogId" : "null").append(",\n")
                    .append("'endTime': curDate,\n")
                    .append("'title': title,\n")
                    .append("'status': 0\n")
                    .append("},\n")
                    .append("'subTypeCategory': 'ATHENA_REMIND',\n")
                    .append("'subType': '',\n")
                    .append("'startTime': curDate,\n")
                    .append("'state': 0,\n")
                    .append("'endTime': curDate,\n")
                    .append("'category': ").append(jumpTaskDetail ? "'OTHER'" : "'NOTICE'").append(",\n")
                    .append("'hasReadDetail': false\n")
                    .append("    \n")
                    .append("}}}).filter(Boolean);\n") // Remove null entries
                    .append("return request;");

        } else {
            // 接收人选择了机制参数
            requestScriptSb.append("var list = $(list);\n")
                    .append("var userId = list && list.length > 0 ? " + userId + " : [];\n");
            // String performerType = convert.getPerformerType();
            // if ("MECHANISM_PARAMETER".equals(performerType)) {
            // // 加一个判断，如果前面过滤的数据，如果没有数据了，就把接收人清空
            // requestScriptSb.append("var list = $(taskBizData);\n")
            // .append("var userId = list && list.length > 0 ? "+ userId +" : [];\n"); // 不转成字符串
            // } else {
            // requestScriptSb.append("var userId = "+ userId +";\n");
            // }
            requestScriptSb.append("var tenantId = '$(tenantId)';\n")
                    .append("var processLocale = '$(processLocale)';\n")
                    .append("var curDate = new Date();\n")
                    .append("var title = '" + title + "';\n")
                    .append("var msg = '" + msgLangMap.get("zh_CN") + "';\n")
                    .append("if (processLocale === 'zh_TW') {\n")
                    .append("title = '" + titleTW + "';\n")
                    .append("msg = '" + msgLangMap.get("zh_TW") + "';\n}")
                    .append("else if (processLocale === 'en_US') {\n ")
                    .append("title = '" + titleEn + "';\n")
                    .append("msg = '" + msgLangMap.get("en_US") + "';\n}\n")
                    .append("var request = [{\n ")
                    // .append("'userIdList': [userId],\n ")
                    .append("'userIdList': typeof userId === 'string' ? [userId]:userId,\n ")
                    .append("'tenantId': tenantId,\n")
                    .append("'message': {\n")
                    .append("'sendDate': curDate,\n")
                    .append("'importance': 0,\n")
                    .append("'source': 'athena',\n")
                    .append("'type': 'activity',\n")
                    .append("'title': title,\n")
                    .append("'content': {\n")
                    .append("'msg': msg,\n ")
                    .append("'name': '',\n")
                    .append("'startTime': curDate,\n")
                    .append("'id': null,\n")
                    .append("'endTime': curDate,\n")
                    .append("'title': title,\n")
                    .append("'status': 0\n")
                    .append("},\n")
                    .append("'subTypeCategory': 'ATHENA_REMIND',\n")
                    .append("'subType': '',\n")
                    .append("'startTime': curDate,\n")
                    .append("'state': 0,\n")
                    .append("'endTime': curDate,\n")
                    .append("'category': 'NOTICE',\n")
                    .append("'hasReadDetail': false\n")
                    .append("}\n}];\n")
                    .append("return request;");
        }

        return requestScriptSb.toString();
    }

    private Map<String, String> processLangAndLinks(IMActivityWidget convert, String message) {
        Map<String, String> result = new HashMap<>();
        String messageEN = message;
        String messageTW = message;
        Map<String, Map<String, String>> lang = convert.getLang();
        if (lang != null) {
            Map<String, String> langMessage = lang.get("message");
            if (langMessage != null) {
                messageTW = langMessage.getOrDefault("zh_TW", messageTW);
                messageEN = langMessage.getOrDefault("en_US", messageEN);
            }
        }
        message = replaceSpecialCharacters(message);
        messageEN = replaceSpecialCharacters(messageEN);
        messageTW = replaceSpecialCharacters(messageTW);
        if (CollectionUtils.isNotEmpty(convert.getLinks())) {
            for (ImLinkDTO link : convert.getLinks()) {
                NoticeLinkEnum noticeLinkEnum = NoticeLinkEnum.getByType(link.getType());
                if (noticeLinkEnum != null && !noticeLinkEnum.equals(NoticeLinkEnum.TASK_DETAIL)) {
                    String urlCn = noticeLinkEnum.getUrlCn().replaceAll("#atheanaDomain#", athenaUrl);
                    String urlTw = noticeLinkEnum.getUrlTw().replaceAll("#atheanaDomain#", athenaUrl);
                    String urlUs = noticeLinkEnum.getUrlUs().replaceAll("#atheanaDomain#", athenaUrl);
                    String placeHolder = link.getPlaceHolder();
                    if (StringUtils.isNotBlank(placeHolder)) {
                        if (StringUtils.isNotEmpty(message)) {
                            message = message.replaceAll(placeHolder, urlCn);
                        }
                        if (StringUtils.isNotEmpty(messageEN)) {
                            messageEN = messageEN.replaceAll(placeHolder, urlUs);

                        }
                        if (StringUtils.isNotEmpty(messageTW)) {
                            messageTW = messageTW.replaceAll(placeHolder, urlTw);
                        }
                    } else {
                        if (StringUtils.isNotEmpty(message)) {
                            message += urlCn;
                        }
                        if (StringUtils.isNotEmpty(messageEN)) {
                            messageEN += urlUs;
                        }
                        if (StringUtils.isNotEmpty(messageTW)) {
                            messageTW += urlTw;
                        }
                    }
                }
            }
        }
        result.put("zh_CN", message);
        result.put("zh_TW", messageTW);
        result.put("en_US", messageEN);
        return result;
    }

    /**
     * 替换特殊字符，现在只改了单引号
     * @param s 字符串
     * @return 替换后的字符串
     */
    private String replaceSpecialCharacters(String s) {
        return Optional.ofNullable(s).filter(str -> str.contains("'")).map(str -> str.replaceAll("'", "\\\\'")).orElse(s);
    }

    private String getIMHandRequestScript(IMActivityWidget convert) {
        String message = convert.getMessage();
        if (message.contains("\n")) {
            message = message.replaceAll("\n", "");
        }
        StringBuilder requestScriptSb = new StringBuilder();
        requestScriptSb.append("var tenantId = '$(tenantId)';\n")
                .append("var taskList = '$(bizData)';\n")
                .append("var msg = '" + message + "';\n")
                .append("var request = {\n ")
                .append("'tenantId': tenantId,\n ")
                .append("'taskList': taskList,\n")
                .append("'msg': msg\n")
                .append("};\n")
                .append("return request;");
        return requestScriptSb.toString();
    }

    private String getIMHandRequestScriptApi(IMActivityWidget convert) {
        String message = convert.getMessage();
        if (message.contains("\n")) {
            message = message.replaceAll("\n", "");
        }
        Map<String, String> msgLangMap = processLangAndLinks(convert, message);
        StringBuilder requestScriptSb = new StringBuilder();
        requestScriptSb.append("var tenantId = '$(tenantId)';\n")
                .append("var taskBizDataList = '$(taskBizData)';\n")
                .append("var processLocale = '$(processLocale)';\n")
                .append("var msg = processLocale === 'zh_TW' ? '" + msgLangMap.get("zh_TW") + "': processLocale === 'en_US' ? '" + msgLangMap.get("en_US") + "':'" + msgLangMap.get("zh_CN") + "';\n")
                .append("var request = {\n ")
                .append("'taskBizData': taskBizDataList,\n")
                .append("'tenantId': tenantId,\n ")
                .append("'message': msg,\n");
        if (StringUtils.isNotEmpty(convert.getUserId())) {
            requestScriptSb.append("'userIds': ").append(convert.getUserId()).append(",\n ");
        }
        requestScriptSb.append("'businessFields': '" + convert.getPerformerValue() + "'\n ")
                .append("};\n")
                .append("return request;");
        return requestScriptSb.toString();
    }

    private String getIMTemplateRequestScript(IMActivityWidget convert) {
        String message = convert.getMessage();
        String title = convert.getTitle();
        String titleEn = title;
        String titleTW = title;

        Map<String, Map<String, String>> lang = convert.getLang();
        if (lang != null) {
            Map<String, String> langTitle = lang.get("title");
            if (langTitle != null) {
                titleTW = langTitle.getOrDefault("zh_TW", titleTW);
                titleEn = langTitle.getOrDefault("en_US", titleEn);
            }
        }
        Map<String, String> msgLangMap = processLangAndLinks(convert, message);
        StringBuilder requestScriptSb = new StringBuilder();
        String template = StringUtils.isNotEmpty(convert.getMsgCode()) ? parseVariables(convert.getMsgCode(), message) : ""; // 解析message获取template
        // 是否需要跳转到任务详情
        boolean jumpTaskDetail = CollectionUtils.isNotEmpty(convert.getLinks()) && convert.getLinks().stream().anyMatch(link -> NoticeLinkEnum.TASK_DETAIL.getType().equals(link.getType()));
        if (jumpTaskDetail) {
            requestScriptSb.append("var tenantId = '$(tenantId)';\n")
                    .append("var processLocale = '$(processLocale)';\n")
                    .append("var userArrayObject = $(list);\n")
                    .append("var curDate = new Date();\n")
                    .append("var userId = " + "[$(_imUserList)]" + ";\n") // 取值后变为字符串,设置为_imUserList
                    .append("var title = '" + title + "';\n")
                    .append("var msg = '" + msgLangMap.get("zh_CN") + "';\n");
            if (StringUtils.isNotEmpty(convert.getMsgCode())) {
                requestScriptSb.append("var template = " + template + ";\n");
            }

            requestScriptSb.append("if (processLocale === 'zh_TW') {\n")
                    .append("title = '" + titleTW + "';\n")
                    .append("msg = '" + msgLangMap.get("zh_TW") + "';\n}")
                    .append("else if (processLocale === 'en_US') {\n ")
                    .append("title = '" + titleEn + "';\n")
                    .append("msg = '" + msgLangMap.get("en_US") + "';\n}\n")
                    .append(" var request = userArrayObject.map(function (info) {")
                    .append(" return {\n")
                    .append("'userIdList': userId,\n")
                    .append("'tenantId': tenantId,\n")
                    .append("'message': {\n");
            if (StringUtils.isNotEmpty(convert.getMsgCode())) {
                requestScriptSb.append("'template': template,\n ");
            }
            requestScriptSb.append("'sendDate': curDate,\n")
                    .append("'importance': 0,\n")
                    .append("'source': 'athena',\n")
                    .append("'type': 'activity',\n")
                    .append("'title': title,\n")
                    .append("'content': {\n")
                    .append("'msg': msg,\n ")
                    .append("'name': '',\n")
                    .append("'startTime': curDate,\n")
                    .append("'id': ").append("info.backlogId").append(",\n")
                    .append("'endTime': curDate,\n")
                    .append("'title': title,\n")
                    .append("'status': 0\n")
                    .append("},\n")
                    .append("'subTypeCategory': 'ATHENA_REMIND',\n")
                    .append("'subType': '',\n")
                    .append("'startTime': curDate,\n")
                    .append("'state': 0,\n")
                    .append("'endTime': curDate,\n")
                    .append("'category': ").append("'OTHER'").append(",\n")
                    .append("'hasReadDetail': false\n")
                    .append("}\n}});\n")
                    .append("return request;");
        } else {
            requestScriptSb.append("var tenantId = '$(tenantId)';\n")
                    .append("var processLocale = '$(processLocale)';\n")
                    .append("var list = $(list);\n")
                    .append("var curDate = new Date();\n")
                    .append("var userId = " + "[$(_imUserList)]" + ";\n") // 取值后变为字符串,设置为_imUserList
                    .append("var title = '" + title + "';\n")
                    .append("var msg = '" + msgLangMap.get("zh_CN") + "';\n");

            if (StringUtils.isNotEmpty(convert.getMsgCode())) {
                requestScriptSb.append("var template = " + template + ";\n");
            }

            requestScriptSb.append("if (processLocale === 'zh_TW') {\n")
                    .append("title = '" + titleTW + "';\n")
                    .append("msg = '" + msgLangMap.get("zh_TW") + "';\n}")
                    .append("else if (processLocale === 'en_US') {\n ")
                    .append("title = '" + titleEn + "';\n")
                    .append("msg = '" + msgLangMap.get("en_US") + "';\n}\n")
                    .append("if (list.length > 0) {\n")
                    .append("var request = [{\n ")
                    .append("'userIdList': userId,\n ")
                    .append("'tenantId': tenantId,\n")
                    .append("'message': {\n")
                    .append("'sendDate': curDate,\n");

            // 新增template入参
            if (StringUtils.isNotEmpty(convert.getMsgCode())) {
                requestScriptSb.append("'template': template,\n ");
            }
            requestScriptSb.append("'locale': processLocale,\n ");
            requestScriptSb.append("'importance': 0,\n")
                    .append("'source': 'athena',\n")
                    .append("'type': 'activity',\n")
                    .append("'title': title,\n")
                    .append("'content': {\n")
                    .append("'msg': msg,\n ")
                    .append("'name': '',\n")
                    .append("'startTime': curDate,\n")
                    .append("'id': null,\n")
                    .append("'endTime': curDate,\n")
                    .append("'title': title,\n")
                    .append("'status': 0\n")
                    .append("},\n")
                    .append("'subTypeCategory': 'ATHENA_REMIND',\n")
                    .append("'subType': '',\n")
                    .append("'startTime': curDate,\n")
                    .append("'state': 0,\n")
                    .append("'endTime': curDate,\n")
                    .append("'category': 'NOTICE',\n")
                    .append("'hasReadDetail': false\n")
                    .append("}\n}];\n")
                    .append("return request;\n")
                    .append("} else {\n")
                    .append("return;\n")
                    .append("}");
        }
        return requestScriptSb.toString();
    }

}
