package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;

public abstract class AbstractComponentHandler implements ComponentHandler {

    @Override
    public Object handlerApply(MechanismComponentDTO dto) throws Exception {
        BindingContext context = buildContext(dto);
        Object obj = doHandlerApply(dto, context);
        return obj;
    }

    @Override
    public Object handlerUnApply(MechanismComponentDTO dto) throws Exception {
        BindingContext context = buildContext(dto);
        Object obj = doHandlerUnApply(dto, context);
        return obj;
    }

    public abstract Object doHandlerApply(MechanismComponentDTO dto, BindingContext context) throws Exception;

    public abstract Object doHandlerUnApply(MechanismComponentDTO dto, BindingContext context) throws Exception;

    private BindingContext buildContext(MechanismComponentDTO dto) throws DWBusinessException {
        BindingContext context = new BindingContext();
        context.setTenantId(ServiceUtils.getTenantId());
        context.setMechanismCode(dto.getMechanismCode());
        context.setMechanismVersion(dto.getMechanismVersion());
        context.setPluginId(dto.getPluginId());
        context.setParam(dto.getParam());
        context.setMechanismVariables(dto.getMechanismVariables());
        return context;
    }
}
