package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-30 16:41
 **/
@Service
public class DefaultComponentHandler extends AbstractComponentHandler {

    @Autowired
    PluginService pluginService;

    @Override
    public Object doHandlerApply(MechanismComponentDTO dto, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postMergePlugin(binding);
        return null;
    }

    @Override
    public Object doHandlerUnApply(MechanismComponentDTO dto, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postRemovePlugin(binding);
        return null;
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismDefault.name().equalsIgnoreCase(dto.getType());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return null;
    }
}
