package com.digiwin.athena.datamap.mechanism.convert;

import com.digiwin.athena.mechanism.bo.HookBO;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.*;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-31 09:28
 **/
@Data
@Accessors(chain = true)
public class HooksInfo {

    private String hookStr;

    private HookBO hook;

    /**
     * 需要绑定的apiUrl集合
     * 内部元素一般为Map，目前有两类数据 [{type:'api/target',params:{api:api的地址,requestJson:入参参数 }}]
     *
     */
    private List<Object> apiList = new ArrayList<>();

    /**
     * 页面方案
     * key: api条件时为url，一般条件时 sceneOne,sceneTwo
     * value: [{name:value},{name:value}]
     *
     */
    private Map<String, Object> targetMap = new HashMap<>();
    /**
     * 有需要动态替换函数中参数的做法 建议用这个
     */
    private Set<HookDynamicFunction> dynamicFunctions = new HashSet<>();

}
