package com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @Description 去重计数函数解析
 * @Author liugl
 * @Date 2024/7/1 9:53
 **/
@Service
@Slf4j
public class CountDisParser implements CustomFuncParser {

    @Override
    public boolean accept(String type) {
        return MechanismEnum.FunctionType.COUNT_DIS.getCode().equalsIgnoreCase(type);
    }

    @Override
    public String getOutPutTypeByName(String dataType) {
        return MechanismEnum.FunctionType.COUNT_DIS.getOutputType();
    }

    @Override
    public Long parse(MechanismVariable mechanismVariable, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            return null;
        }
        String dataName = mechanismVariable.getData_name();
        long countValue = metaDataList.stream().map(v -> {
            JSONObject metaDataObj = JSON.parseObject(JSON.toJSONString(v));
            return metaDataObj.get(dataName);
        }).filter(v -> v != null).distinct().count();
        return countValue;
    }
}
