package com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;

/**
 * @Description 根据不同的字段类型解析条件
 * @Author liugl
 * @Date 2024/6/28 14:26
 **/
public interface FieldValueTypeParser {

    /**
     * 判断选择解析器
     * @param type
     * @return 结果
     */
    boolean accept(String type);

    /**
     * 判断选择解析器
     *
     * @param conditionConfig 判断条件
     * @param metaDataList    表格数据
     * @return 结果
     */
    JSONArray parse(MechanismConditionConfig conditionConfig, JSONArray metaDataList);

    /**
     * 根据类型opType（相等，或者大于等于之类）判断source数据是否与目标数据
     * @param source
     * @param targetLeft
     * @param targetRight
     * @param opType
     * @return 返回结果
     */
    Boolean isBothEqual(Object source, Object targetLeft, Object targetRight, String opType);
}
