package com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Description 任务字段解析
 * @Author liugl
 * @Date 2024/7/1 9:53
 **/
@Service
@Slf4j
public class TaskParser implements RightCondTypeParser {

    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.RightCondType.TASK.getCode().equalsIgnoreCase(type);
    }

    @Override
    public CustomFuncResult preParse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        MechanismVariable left = conditionConfig.getLeft();
        MechanismVariable right = conditionConfig.getRight();
        Object functionValue = left.getFunctionValue();
        String opType = conditionConfig.getOpType();
        String outputType = left.getMechanismFunction().getOutputType();
        String dataNameFrom = right.getFrom().getData_name();
        String dataNameTo = right.getTo().getData_name();
        List<Object> resultList = metaDataList.stream().filter(v -> {
            JSONObject metaDataObj = JSON.parseObject(JSON.toJSONString(v));
            // 判断两者是否相等
            return mechanismParserFactory.getFieldTypeParserByConfig(outputType)
                    .isBothEqual(functionValue, getArrayChild(functionValue, metaDataObj, dataNameFrom, opType, "left"),
                            getArrayChild(functionValue, metaDataObj, dataNameTo, opType, "right"), opType);
        }).collect(Collectors.toList());
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE)
                .setMetaDataList(JSONArray.parseArray(JSON.toJSONString(resultList)));
    }

    /**
     * 获取数组子级数据(目前只考虑数值类型)
     *
     * @param metaDataObj
     * @param name
     * @return
     */
    private Object getArrayChild(Object functionValue, JSONObject metaDataObj, String name, String opType, String type) {
        if (ObjectUtils.isEmpty(name)) {
            return null;
        }
        if (!name.contains(".")) {
            return metaDataObj.get(name);
        }
        String[] names = name.split("[/.]");
        Object parent = metaDataObj.get(names[0]);
        JSONArray parentArray = JSON.parseArray(JSON.toJSONString(parent));
        if (MechanismEnum.OperateType.GT.getCode().equals(opType) || MechanismEnum.OperateType.GTE.equals(opType)) {
            Optional<BigDecimal> max = parentArray.stream().map(v -> {
                JSONObject parseObject = JSON.parseObject(JSON.toJSONString(v));
                return parseObject.getBigDecimal(names[1]);
            }).filter(v -> null != v).max(BigDecimal::compareTo);
            return max.isPresent() ? max.get() : null;
        }
        if (MechanismEnum.OperateType.LT.getCode().equals(opType) || MechanismEnum.OperateType.LTE.equals(opType)) {
            Optional<BigDecimal> min = parentArray.stream().map(v -> {
                JSONObject parseObject = JSON.parseObject(JSON.toJSONString(v));
                return parseObject.getBigDecimal(names[1]);
            }).filter(v -> null != v).min(BigDecimal::compareTo);
            return min.isPresent() ? min.get() : null;
        }
        if (MechanismEnum.OperateType.EQ.getCode().equals(opType)) {
            BigDecimal functionValueBigDecimal = new BigDecimal(functionValue.toString());
            Optional<BigDecimal> equal = parentArray.stream().map(v -> {
                JSONObject parseObject = JSON.parseObject(JSON.toJSONString(v));
                return parseObject.getBigDecimal(names[1]);
            }).filter(v -> functionValueBigDecimal.compareTo(v) == 0).findFirst();
            return equal.isPresent() ? equal.get() : null;
        }
        if (MechanismEnum.OperateType.BETWEEN.getCode().equals(opType)) {
            if ("left".equals(type)) {
                Optional<BigDecimal> between = parentArray.stream().map(v -> {
                    JSONObject parseObject = JSON.parseObject(JSON.toJSONString(v));
                    return parseObject.getBigDecimal(names[1]);
                }).filter(v -> null != v).min(BigDecimal::compareTo);
                return between.isPresent() ? between.get() : null;
            }
            if ("right".equals(type)) {
                Optional<BigDecimal> between = parentArray.stream().map(v -> {
                    JSONObject parseObject = JSON.parseObject(JSON.toJSONString(v));
                    return parseObject.getBigDecimal(names[1]);
                }).filter(v -> null != v).max(BigDecimal::compareTo);
                return between.isPresent() ? between.get() : null;
            }
        }
        return null;
    }

    @Override
    public CustomFuncResult parse(MechanismConditionConfig config, JSONObject metaDataObj, JSONArray metaDataList) {
        if (ObjectUtils.isEmpty(metaDataObj) && ObjectUtils.isEmpty(metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        if (ObjectUtils.isEmpty(config.getOpenWindowActionId())) {
            String dataName = config.getLeft().getData_name();
            Object metaData = metaDataObj.getBooleanValue(dataName);
            // 设置数据，具体处理在对应的数值类型处理器中进行
            config.getRight().getTo().setValue(metaData);
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
        }
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
    }
}
